/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.jad.source.rules;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.mtj.core.project.midp.DescriptorPropertyDescription;
import org.eclipse.mtj.core.project.midp.IJADDescriptorsProvider;
import org.eclipse.mtj.internal.core.project.midp.JADAttributesRegistry;
import org.eclipse.swt.graphics.RGB;

public class JadScanner
extends RuleBasedScanner {
    private static final String KEYWORD_COLOR = "mtj.jad.keyword.color";
    private static final String VALUE_COLOR = "mtj.jad.value.color";
    private static final ColorRegistry colorRegistry = new ColorRegistry();

    static {
        colorRegistry.put(KEYWORD_COLOR, new RGB(127, 0, 85));
        colorRegistry.put(VALUE_COLOR, new RGB(0, 0, 0));
    }

    public JadScanner() {
        SingleLineRule singleLineRule;
        IWordDetector iWordDetector = new IWordDetector(){

            public boolean isWordPart(char c) {
                if (c == ':') {
                    return false;
                }
                if (c == '-') {
                    return true;
                }
                return Character.isJavaIdentifierPart(c);
            }

            public boolean isWordStart(char c) {
                return Character.isJavaIdentifierStart(c);
            }
        };
        Token token = new Token((Object)new TextAttribute(colorRegistry.get(KEYWORD_COLOR), null, 1));
        Token token2 = new Token((Object)new TextAttribute(colorRegistry.get(KEYWORD_COLOR), null, 0));
        WordRule wordRule = new WordRule(iWordDetector, (IToken)token2);
        IJADDescriptorsProvider[] iJADDescriptorsProviderArray = JADAttributesRegistry.getAllJADDescriptorProviders();
        int n = 0;
        while (n < iJADDescriptorsProviderArray.length) {
            singleLineRule = iJADDescriptorsProviderArray[n].getDescriptorPropertyDescriptions();
            int n2 = 0;
            while (n2 < ((DescriptorPropertyDescription[])singleLineRule).length) {
                wordRule.addWord(singleLineRule[n2].getPropertyName(), (IToken)token);
                ++n2;
            }
            ++n;
        }
        Token token3 = new Token((Object)new TextAttribute(colorRegistry.get(VALUE_COLOR)));
        singleLineRule = new SingleLineRule(":", null, (IToken)token3, '\\');
        WhitespaceRule whitespaceRule = new WhitespaceRule(new IWhitespaceDetector(){

            public boolean isWhitespace(char c) {
                return Character.isWhitespace(c);
            }
        });
        this.setRules(new IRule[]{wordRule, singleLineRule, whitespaceRule});
    }
}

