/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class XMLDoubleClickStrategy
implements ITextDoubleClickStrategy {
    protected ITextViewer fText;

    public void doubleClicked(ITextViewer iTextViewer) {
        int n = iTextViewer.getSelectedRange().x;
        if (n > 0) {
            this.fText = iTextViewer;
            this.selectWord(n);
        }
    }

    private void selectRange(int n, int n2) {
        int n3 = n + 1;
        int n4 = n2 - n3;
        this.fText.setSelectedRange(n3, n4);
    }

    protected boolean selectWord(int n) {
        IDocument iDocument = this.fText.getDocument();
        try {
            char c;
            int n2 = n;
            while (n2 >= 0) {
                c = iDocument.getChar(n2);
                if (!Character.isJavaIdentifierPart(c) && c != '.') break;
                --n2;
            }
            int n3 = n2;
            n2 = n;
            int n4 = iDocument.getLength();
            while (n2 < n4) {
                c = iDocument.getChar(n2);
                if (!Character.isJavaIdentifierPart(c) && c != '.') break;
                ++n2;
            }
            int n5 = n2;
            this.selectRange(n3, n5);
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }
}

