/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.text;

import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.mtj.internal.ui.editor.text.SelectMarkerRulerAction;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;

public class MTJSelectAnnotationRulerAction
extends SelectMarkerRulerAction {
    private boolean fIsEditable;
    private ITextEditor fTextEditor;
    private Position fPosition;
    private ResourceBundle fBundle;
    private String fPrefix;

    public MTJSelectAnnotationRulerAction(ResourceBundle resourceBundle, String string, ITextEditor iTextEditor, IVerticalRulerInfo iVerticalRulerInfo) {
        super(resourceBundle, string, iTextEditor, iVerticalRulerInfo);
        this.fTextEditor = iTextEditor;
        this.fBundle = resourceBundle;
        this.fPrefix = string;
    }

    public void run() {
        this.runWithEvent(null);
    }

    public void runWithEvent(Event event) {
        if (this.fIsEditable) {
            ITextOperationTarget iTextOperationTarget = (ITextOperationTarget)this.fTextEditor.getAdapter(ITextOperationTarget.class);
            if (iTextOperationTarget != null && iTextOperationTarget.canDoOperation(22)) {
                this.fTextEditor.selectAndReveal(this.fPosition.getOffset(), this.fPosition.getLength());
                iTextOperationTarget.doOperation(22);
            }
            return;
        }
        super.run();
    }

    public void update() {
        this.checkReadOnly();
        if (this.fIsEditable) {
            this.initialize(this.fBundle, String.valueOf(this.fPrefix) + "QuickFix.");
        }
        super.update();
    }

    private void checkReadOnly() {
        this.fPosition = null;
        this.fIsEditable = false;
        AbstractMarkerAnnotationModel abstractMarkerAnnotationModel = this.getAnnotationModel();
        IAnnotationAccessExtension iAnnotationAccessExtension = this.getAnnotationAccessExtension();
        IDocument iDocument = this.getDocument();
        if (abstractMarkerAnnotationModel == null) {
            return;
        }
        Iterator iterator = abstractMarkerAnnotationModel.getAnnotationIterator();
        int n = Integer.MIN_VALUE;
        while (iterator.hasNext()) {
            boolean bl;
            Position position;
            Annotation annotation = (Annotation)iterator.next();
            if (annotation.isMarkedDeleted()) continue;
            int n2 = iAnnotationAccessExtension.getLayer(annotation);
            if (iAnnotationAccessExtension != null && n2 < n || !this.includesRulerLine(position = abstractMarkerAnnotationModel.getPosition(annotation), iDocument)) continue;
            boolean bl2 = bl = this.fTextEditor instanceof ITextEditorExtension && ((ITextEditorExtension)this.fTextEditor).isEditorInputReadOnly();
            if (bl) continue;
            this.fPosition = position;
            this.fIsEditable = true;
            n = n2;
        }
    }
}

