/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mtj.internal.core.IBaseModel;
import org.eclipse.mtj.internal.core.IModelChangedEvent;
import org.eclipse.mtj.internal.core.IModelChangedListener;
import org.eclipse.mtj.internal.ui.editor.IContextPart;
import org.eclipse.mtj.internal.ui.editor.MTJFormPage;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class MTJSection
extends SectionPart
implements IModelChangedListener,
IContextPart,
IAdaptable {
    private MTJFormPage fPage;

    public MTJSection(MTJFormPage mTJFormPage, Composite composite, int n) {
        this(mTJFormPage, composite, n, true);
    }

    public MTJSection(MTJFormPage mTJFormPage, Composite composite, int n, boolean bl) {
        super(composite, mTJFormPage.getManagedForm().getToolkit(), bl ? 0x100 | n : n);
        this.fPage = mTJFormPage;
        this.initialize(mTJFormPage.getManagedForm());
        this.getSection().clientVerticalSpacing = 6;
        this.getSection().setData("part", (Object)this);
    }

    public void cancelEdit() {
        super.refresh();
    }

    public boolean canCopy(ISelection iSelection) {
        return false;
    }

    public boolean canCut(ISelection iSelection) {
        return false;
    }

    public boolean canPaste(Clipboard clipboard) {
        return false;
    }

    public boolean doGlobalAction(String string) {
        return false;
    }

    public void fireSaveNeeded() {
        this.markDirty();
        if (this.getContextId() != null) {
            this.getPage().getMTJEditor().fireSaveNeeded(this.getContextId(), false);
        }
    }

    public Object getAdapter(Class clazz) {
        return null;
    }

    public String getContextId() {
        return null;
    }

    public MTJFormPage getPage() {
        return this.fPage;
    }

    public boolean isEditable() {
        IBaseModel iBaseModel = this.getPage().getMTJEditor().getAggregateModel();
        return iBaseModel == null ? false : iBaseModel.isEditable();
    }

    public void modelChanged(IModelChangedEvent iModelChangedEvent) {
        if (iModelChangedEvent.getChangeType() == 99) {
            this.markStale();
        }
    }

    protected abstract void createClient(Section var1, FormToolkit var2);

    protected IProject getProject() {
        return this.fPage.getMTJEditor().getCommonProject();
    }
}

