/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.mtj.internal.ui.editor.text.ChangeAwareSourceViewerConfiguration;
import org.eclipse.mtj.internal.ui.util.SourceViewerDecorator;
import org.eclipse.swt.widgets.Composite;

public class MTJProjectionViewer
extends SourceViewerDecorator {
    public static final int QUICK_OUTLINE = 513;
    private boolean fIsQuickOutlineEnabled;
    private IInformationPresenter fOutlinePresenter;

    public MTJProjectionViewer(Composite composite, IVerticalRuler iVerticalRuler, IOverviewRuler iOverviewRuler, boolean bl, int n, boolean bl2) {
        super((SourceViewer)new ProjectionViewer(composite, iVerticalRuler, iOverviewRuler, bl, n));
        this.fIsQuickOutlineEnabled = bl2;
    }

    public boolean canDoOperation(int n) {
        if (n == 513) {
            return this.fOutlinePresenter != null;
        }
        return super.canDoOperation(n);
    }

    public void configure(SourceViewerConfiguration sourceViewerConfiguration) {
        if (this.getTextWidget() == null || this.getTextWidget().isDisposed()) {
            return;
        }
        super.configure(sourceViewerConfiguration);
        if (this.fIsQuickOutlineEnabled && sourceViewerConfiguration instanceof ChangeAwareSourceViewerConfiguration) {
            ChangeAwareSourceViewerConfiguration changeAwareSourceViewerConfiguration = (ChangeAwareSourceViewerConfiguration)sourceViewerConfiguration;
            this.fOutlinePresenter = changeAwareSourceViewerConfiguration.getOutlinePresenter((ISourceViewer)this);
            if (this.fOutlinePresenter != null) {
                this.fOutlinePresenter.install((ITextViewer)this);
            }
        }
    }

    public void doOperation(int n) {
        if (this.getTextWidget() == null || this.getTextWidget().isDisposed()) {
            return;
        }
        if (n == 513) {
            if (this.fOutlinePresenter != null) {
                this.fOutlinePresenter.showInformation();
            }
            return;
        }
        super.doOperation(n);
    }

    public void unconfigure() {
        if (this.fOutlinePresenter != null) {
            this.fOutlinePresenter.uninstall();
            this.fOutlinePresenter = null;
        }
        super.unconfigure();
    }
}

