/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.dialog;

import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.devices.DeviceSelector;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DeviceMatchDialog
extends MessageDialogWithToggle {
    private DeviceSelector deviceSelector;
    private IDevice matchedDevice;
    private String deviceGroup;
    private String deviceName;
    private String previousDeviceName;
    private String configurationName = null;
    private Text configurationNameText;

    public DeviceMatchDialog(Shell shell) {
        super(shell, MTJUIMessages.DeviceMatchDialog_DialogTitle, null, null, 0, new String[]{MTJUIMessages.DeviceMatchDialog_OKButton, MTJUIMessages.DeviceMatchDialog_CancelButton}, 0, MTJUIMessages.DeviceMatchDialog_ToggleButton, false);
        this.setShellStyle(67616);
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            this.matchedDevice = this.deviceSelector.getSelectedDevice();
            if (this.configurationNameText != null) {
                this.configurationName = this.configurationNameText.getText();
            }
        }
        super.buttonPressed(n);
    }

    protected Control createCustomArea(Composite composite) {
        Label label;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, true));
        composite2.setLayoutData((Object)new GridData(1808));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(1808));
        composite3.setLayout((Layout)new GridLayout(2, false));
        if (this.configurationName != null) {
            label = new Label(composite3, 0);
            label.setText(MTJUIMessages.Configuration_ConfigurationAddWizardPage_NewConfigurationName);
            this.configurationNameText = new Text(composite3, 2048);
            this.configurationNameText.setLayoutData((Object)new GridData(1808));
        }
        label = new Group(composite2, 0);
        label.setText(MTJUIMessages.DeviceMatchDialog_GroupToMatch);
        label.setLayoutData((Object)new GridData(1808));
        label.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)label, 0).setText(MTJUIMessages.DeviceMatchDialog_GroupToMatchDesc);
        new Label((Composite)label, 0);
        Composite composite4 = new Composite((Composite)label, 0);
        composite4.setLayout((Layout)new GridLayout(2, false));
        new Label(composite4, 0).setText(MTJUIMessages.DeviceSelector_4);
        Label label2 = new Label(composite4, 0);
        label2.setText(this.getDeviceGroup());
        new Label(composite4, 0).setText(MTJUIMessages.DeviceSelector_device_label);
        Label label3 = new Label(composite4, 0);
        label3.setText(this.getDeviceName());
        this.deviceSelector = new DeviceSelector();
        this.deviceSelector.setDeviceGroupLabel(MTJUIMessages.DeviceMatchDialog_GroupInstalled);
        this.deviceSelector.setDeviceGroupComentLabel(MTJUIMessages.DeviceMatchDialog_GroupInstalledDesc);
        this.deviceSelector.createContents(composite2, true, true);
        this.previousDeviceName = this.getDeviceName();
        this.deviceSelector.setSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (DeviceMatchDialog.this.configurationNameText != null && DeviceMatchDialog.this.previousDeviceName.equals(DeviceMatchDialog.this.configurationNameText.getText())) {
                    DeviceMatchDialog.this.configurationNameText.setText(DeviceMatchDialog.this.deviceSelector.getSelectedDevice().getName());
                    DeviceMatchDialog.this.previousDeviceName = DeviceMatchDialog.this.deviceSelector.getSelectedDevice().getName();
                }
            }
        });
        if (this.configurationNameText != null) {
            this.configurationNameText.setText(this.configurationName);
        }
        return composite2;
    }

    private String getDeviceName() {
        return this.deviceName;
    }

    private String getDeviceGroup() {
        return this.deviceGroup;
    }

    public void setDeviceGroup(String string) {
        this.deviceGroup = string;
    }

    public void setDeviceName(String string) {
        this.deviceName = string;
    }

    public IDevice getSelectedDevice() {
        return this.matchedDevice;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public void setConfigurationName(String string) {
        this.configurationName = string;
    }
}

