/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.actions.packaging;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.project.runtime.MTJRuntimeListUtils;
import org.eclipse.mtj.internal.core.util.LoggingSafeRunnable;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.actions.AbstractJavaProjectAction;
import org.eclipse.mtj.internal.ui.actions.ConfigurationErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractCreatePackageAction
extends AbstractJavaProjectAction {
    public void run(IAction iAction) {
        if (this.selection != null && !this.selection.isEmpty()) {
            boolean bl = true;
            if (this.shouldObfuscate() && !this.selection.isEmpty()) {
                bl = this.isProguardConfigurationValid();
            }
            if (!bl) {
                this.warnAboutProguardConfiguration();
            } else {
                try {
                    this.doPackageCreation();
                }
                catch (CoreException coreException) {
                    MTJLogger.log((int)4, (String)MTJUIMessages.AbstractCreatePackageAction_error_creating_package, (Throwable)coreException);
                }
            }
        }
    }

    public void run(IJavaProject iJavaProject, IWorkbenchPart iWorkbenchPart) {
        boolean bl = true;
        if (this.shouldObfuscate()) {
            bl = this.isProguardConfigurationValid();
        }
        if (!bl) {
            this.warnAboutProguardConfiguration();
        } else {
            try {
                this.doPackageCreation(iJavaProject, iWorkbenchPart);
            }
            catch (Throwable throwable) {
                MTJLogger.log((int)4, (String)MTJUIMessages.AbstractCreatePackageAction_error_creating_package, (Throwable)throwable);
            }
        }
    }

    private void createPackageForProject(IProgressMonitor iProgressMonitor, IJavaProject iJavaProject) {
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)iJavaProject);
        if (this.configurationsIsDirty((IMTJProject)iMidletSuiteProject)) {
            return;
        }
        boolean bl = this.needPackageInactiveConfigs((IMTJProject)iMidletSuiteProject);
        try {
            iMidletSuiteProject.createPackage(this.shouldObfuscate(), bl, iProgressMonitor);
        }
        catch (CoreException coreException) {
            MTJLogger.log((int)4, (String)MTJUIMessages.AbstractCreatePackageAction_error_createPackageForProject, (Throwable)coreException);
            ErrorDialog.openError((Shell)this.getShell(), (String)MTJUIMessages.bind((String)MTJUIMessages.AbstractCreatePackageAction_createPackageForProject_dialog_message, (Object)iJavaProject.getElementName()), (String)coreException.getMessage(), (IStatus)coreException.getStatus());
        }
    }

    private boolean configurationsIsDirty(IMTJProject iMTJProject) {
        if (MTJRuntimeListUtils.isMTJRuntimeListDirty((IMTJProject)iMTJProject)) {
            MessageDialog.openWarning(null, (String)MTJUIMessages.Configuration_WarningMessage_ConfigurationsDirty_Title, (String)MTJUIMessages.Configuration_WarningMessage_ConfigurationsDirty_Message);
            return true;
        }
        return false;
    }

    private boolean needPackageInactiveConfigs(IMTJProject iMTJProject) {
        boolean bl = false;
        if (iMTJProject.getRuntimeList().size() == 1) {
            return bl;
        }
        bl = MessageDialog.openQuestion(null, (String)MTJUIMessages.Configuration_QuestionMessage_PackageAllConfigs_Title, (String)MTJUIMessages.Configuration_QuestionMessage_PackageAllConfigs_Message);
        return bl;
    }

    private boolean doesProjectHaveValidDevice(IJavaProject iJavaProject) {
        boolean bl = false;
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)iJavaProject);
        if (iMidletSuiteProject != null) {
            IMIDPDevice iMIDPDevice = (IMIDPDevice)iMidletSuiteProject.getRuntimeList().getActiveMTJRuntime().getDevice();
            bl = iMIDPDevice != null;
        }
        return bl;
    }

    private void doPackageCreation() throws CoreException {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.workbenchPart.getSite().getShell());
        progressMonitorDialog.open();
        final IProgressMonitor iProgressMonitor = progressMonitorDialog.getProgressMonitor();
        iProgressMonitor.beginTask(MTJUIMessages.AbstractCreatePackageAction_doPackageCreation_task_name, 3);
        Iterator iterator = this.selection.iterator();
        while (iterator.hasNext()) {
            final IJavaProject iJavaProject = this.getJavaProject(iterator.next());
            if (iJavaProject == null) continue;
            if (this.doesProjectHaveValidDevice(iJavaProject)) {
                SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                    public void run() throws Exception {
                        AbstractCreatePackageAction.this.createPackageForProject(iProgressMonitor, iJavaProject);
                    }
                });
                continue;
            }
            this.warnAboutInvalidDevice(iJavaProject);
        }
        iProgressMonitor.done();
        progressMonitorDialog.close();
    }

    private void doPackageCreation(final IJavaProject iJavaProject, IWorkbenchPart iWorkbenchPart) {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(iWorkbenchPart.getSite().getShell());
        progressMonitorDialog.open();
        final IProgressMonitor iProgressMonitor = progressMonitorDialog.getProgressMonitor();
        iProgressMonitor.beginTask(MTJUIMessages.AbstractCreatePackageAction_doPackageCreation_task_name, 3);
        if (iJavaProject != null) {
            if (this.doesProjectHaveValidDevice(iJavaProject)) {
                SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                    public void run() throws Exception {
                        AbstractCreatePackageAction.this.createPackageForProject(iProgressMonitor, iJavaProject);
                    }
                });
            } else {
                this.warnAboutInvalidDevice(iJavaProject);
            }
        }
        iProgressMonitor.done();
        progressMonitorDialog.close();
    }

    private boolean isProguardConfigurationValid() {
        return MTJCore.getProguardJarFile().exists();
    }

    private void warnAboutInvalidDevice(IJavaProject iJavaProject) {
        String string = MTJUIMessages.bind((String)MTJUIMessages.AbstractCreatePackageAction_warnAboutInvalidDevice_message, (Object[])new String[]{iJavaProject.getElementName(), iJavaProject.getElementName()});
        MessageDialog.openWarning((Shell)this.getShell(), (String)MTJUIMessages.AbstractCreatePackageAction_warnAboutInvalidDevice_dialog_title, (String)string);
    }

    private void warnAboutProguardConfiguration() {
        String string = MTJUIMessages.AbstractCreatePackageAction_warnAboutProguardConfiguration_message;
        ConfigurationErrorDialog configurationErrorDialog = new ConfigurationErrorDialog(this.getShell(), "org.eclipse.mtj.ui.preferences.J2MEPreferencePage", MTJUIMessages.AbstractCreatePackageAction_warnAboutProguardConfiguration_dialog_title, string, MTJUIMessages.AbstractCreatePackageAction_warnAboutProguardConfiguration__configure_btn);
        configurationErrorDialog.open();
    }

    protected abstract boolean shouldObfuscate();
}

