/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.actions.l10n;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mtj.internal.core.l10n.L10nApi;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.actions.AbstractJavaProjectAction;
import org.eclipse.mtj.internal.ui.actions.l10n.EnableLocalizationAction;
import org.eclipse.mtj.internal.ui.dialog.StringLocalizationCandidatesDialog;
import org.eclipse.mtj.internal.ui.wizards.l10n.StringLocalizationWizard;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizeStringsAction
extends AbstractJavaProjectAction {
    public void run(IAction iAction) {
        try {
            Object object;
            L10nLocale l10nLocale;
            L10nLocales l10nLocales;
            Object object2;
            IJavaProject iJavaProject = this.getJavaProject(this.selection);
            if (iJavaProject == null) {
                return;
            }
            IProject iProject = iJavaProject.getProject();
            if (!iProject.hasNature("org.eclipse.mtj.core.l10nNature")) {
                object2 = new EnableLocalizationAction();
                ((AbstractJavaProjectAction)object2).selectionChanged(iAction, (ISelection)new StructuredSelection((Object)iJavaProject));
                ((EnableLocalizationAction)object2).run(iAction);
                if (!iProject.hasNature("org.eclipse.mtj.core.l10nNature")) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)MTJUIMessages.LocalizeStringsAction_errorDialogTitle, (String)MTJUIMessages.LocalizeStringsAction_projectL10nNotEnabled);
                    return;
                }
            }
            if ((l10nLocales = (object2 = L10nApi.loadL10nModel((IProject)iProject)).getLocales()).getChildCount() == 0) {
                l10nLocale = new L10nLocale((L10nModel)object2);
                l10nLocale.setLanguageCode("en");
                l10nLocale.setCountryCode("US");
                l10nLocales.addChild((L10nObject)l10nLocale);
                object2.save();
            }
            if (((L10nLocale)(l10nLocale = this.getCandiateClasses())).length == 0) {
                return;
            }
            L10nLocale l10nLocale2 = null;
            if (((L10nLocale)l10nLocale).length > 1) {
                object = new StringLocalizationCandidatesDialog(this.getShell(), (ICompilationUnit[])l10nLocale);
                if (object.open() == 0) {
                    l10nLocale2 = object.getSelectedClass();
                }
            } else {
                l10nLocale2 = l10nLocale[0];
            }
            if (l10nLocale2 != null) {
                object = new StringLocalizationWizard((ICompilationUnit)l10nLocale2, (L10nModel)object2);
                WizardDialog wizardDialog = new WizardDialog(this.getShell(), (IWizard)object);
                wizardDialog.create();
                wizardDialog.open();
            }
        }
        catch (CoreException coreException) {
            MTJLogger.log((int)4, (Throwable)coreException);
        }
    }

    private ICompilationUnit[] getCandiateClasses() {
        ArrayList<ICompilationUnit> arrayList = new ArrayList<ICompilationUnit>();
        if (this.selection != null && !this.selection.isEmpty()) {
            Object[] objectArray;
            Object[] objectArray2 = objectArray = this.selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment iPackageFragment;
                Object object = objectArray2[n2];
                if (object instanceof ICompilationUnit) {
                    arrayList.add((ICompilationUnit)object);
                } else if (object instanceof IPackageFragment) {
                    iPackageFragment = (IPackageFragment)object;
                    this.collectPackageClasses(arrayList, iPackageFragment);
                } else if (object instanceof IPackageFragmentRoot) {
                    iPackageFragment = (IPackageFragmentRoot)object;
                    this.collectSourceClasses(arrayList, (IPackageFragmentRoot)iPackageFragment);
                } else if (object instanceof IJavaProject) {
                    iPackageFragment = (IJavaProject)object;
                    this.collectProjectClasses(arrayList, (IJavaProject)iPackageFragment);
                }
                ++n2;
            }
        }
        return arrayList.toArray(new ICompilationUnit[0]);
    }

    private void collectProjectClasses(List<ICompilationUnit> list, IJavaProject iJavaProject) {
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray;
            IPackageFragmentRoot[] iPackageFragmentRootArray2 = iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray2[n2];
                if (iPackageFragmentRoot.getKind() == 1) {
                    this.collectSourceClasses(list, iPackageFragmentRoot);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            MTJLogger.log((int)4, (Throwable)javaModelException);
        }
    }

    private void collectSourceClasses(List<ICompilationUnit> list, IPackageFragmentRoot iPackageFragmentRoot) {
        try {
            IJavaElement[] iJavaElementArray;
            IJavaElement[] iJavaElementArray2 = iJavaElementArray = iPackageFragmentRoot.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement iJavaElement = iJavaElementArray2[n2];
                if (iJavaElement instanceof IPackageFragment) {
                    this.collectPackageClasses(list, (IPackageFragment)iJavaElement);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            MTJLogger.log((int)4, (Throwable)javaModelException);
        }
    }

    private void collectPackageClasses(List<ICompilationUnit> list, IPackageFragment iPackageFragment) {
        try {
            IJavaElement[] iJavaElementArray;
            IJavaElement[] iJavaElementArray2 = iJavaElementArray = iPackageFragment.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement iJavaElement = iJavaElementArray2[n2];
                if (iJavaElement instanceof IPackageFragment) {
                    this.collectPackageClasses(list, (IPackageFragment)iJavaElement);
                } else if (iJavaElement instanceof ICompilationUnit) {
                    list.add((ICompilationUnit)iJavaElement);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            MTJLogger.log((int)4, (Throwable)javaModelException);
        }
    }

    @Override
    protected IJavaProject getJavaProject(Object object) {
        IJavaProject iJavaProject = super.getJavaProject(object);
        if (iJavaProject == null && object instanceof IStructuredSelection) {
            Object object2 = this.selection.getFirstElement();
            if (object2 instanceof IJavaProject) {
                iJavaProject = (IJavaProject)object2;
            } else if (object2 instanceof IJavaElement) {
                iJavaProject = ((IJavaElement)object2).getJavaProject();
            }
        }
        return iJavaProject;
    }
}

