/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.toolkit.mpowerplayer;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.sdk.ISDK;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.ILibraryImporter;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPLibrary;
import org.eclipse.mtj.core.sdk.device.midp.MIDPAPIType;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.sdk.BasicSDK;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDeviceImporter;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDeviceProperties;
import org.eclipse.mtj.internal.core.sdk.device.midp.Configuration;
import org.eclipse.mtj.internal.core.sdk.device.midp.Profile;
import org.eclipse.mtj.internal.core.util.ReplaceableParametersProcessor;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.toolkit.mpowerplayer.Messages;
import org.eclipse.mtj.internal.toolkit.mpowerplayer.MpowerplayerDevice;
import org.eclipse.mtj.internal.toolkit.mpowerplayer.MpowerplayerPlugin;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MpowerplayerDeviceImporter
extends JavaEmulatorDeviceImporter {
    private static final String MACOSX_OS_NAME = "Mac OS X";
    private static String osName = System.getProperty("os.name");
    private static final String PLAYER_JAR_NAME = "player.jar";
    private static final String PLAYER_MACOSX_PREVERIFIER = "/osx/preverify";
    private static final String PLAYER_MAIN_CLASS = "com.mpp.player.PowerPlayerApp";
    private static final String PROPS_FILE = "mpowerplayer.properties";

    public List<IDevice> importDevices(File file, IProgressMonitor iProgressMonitor) {
        ArrayList<IDevice> arrayList = null;
        try {
            IDevice iDevice;
            File file2 = new File(file, PLAYER_JAR_NAME);
            if (file2.exists() && this.hasMainClassAttribute(file2, PLAYER_MAIN_CLASS) && (iDevice = this.createDevice(file2)) != null) {
                arrayList = new ArrayList<IDevice>(1);
                arrayList.add(iDevice);
            }
        }
        catch (Exception exception) {
            MTJLogger.log((int)2, (String)Messages.MpowerplayerDeviceImporter_import_error, (Throwable)exception);
        }
        return arrayList;
    }

    private void addMplayerDeviceLibraries(File file, IDeviceClasspath iDeviceClasspath, ILibraryImporter iLibraryImporter) {
        String[] stringArray;
        String string = this.getDeviceProperties().getProperty(JavaEmulatorDeviceProperties.CLASSPATH.toString(), "");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("mpproot", file.getParent());
        string = ReplaceableParametersProcessor.processReplaceableValues((String)string, hashMap);
        String[] stringArray2 = stringArray = string.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            IMIDPLibrary iMIDPLibrary = (IMIDPLibrary)iLibraryImporter.createLibraryFor(new File(string2));
            IMIDPAPI iMIDPAPI = iMIDPLibrary.getAPI(MIDPAPIType.UNKNOWN);
            if (iMIDPAPI != null) {
                if (iMIDPAPI.getIdentifier().equalsIgnoreCase("cldc-1.1.jar")) {
                    iMIDPAPI.setIdentifier(Configuration.CLDC_11.getIdentifier());
                    iMIDPAPI.setType(MIDPAPIType.CONFIGURATION);
                    iMIDPAPI.setName(Configuration.CLDC_11.getName());
                    iMIDPAPI.setVersion(Configuration.CLDC_11.getVersion());
                } else if (iMIDPAPI.getIdentifier().equalsIgnoreCase("midp-2.0.jar")) {
                    iMIDPAPI.setIdentifier(Profile.MIDP_20.getIdentifier());
                    iMIDPAPI.setType(MIDPAPIType.PROFILE);
                    iMIDPAPI.setName(Profile.MIDP_20.getName());
                    iMIDPAPI.setVersion(Profile.MIDP_20.getVersion());
                } else if (iMIDPAPI.getIdentifier().equalsIgnoreCase("m2d.jar")) {
                    iMIDPAPI.setIdentifier("JSR226");
                    iMIDPAPI.setType(MIDPAPIType.OPTIONAL);
                    iMIDPAPI.setName("Scalable 2D Vector Graphics API for J2ME");
                    iMIDPAPI.setVersion(new Version("1.0"));
                } else if (iMIDPAPI.getIdentifier().equalsIgnoreCase("m3g.jar")) {
                    iMIDPAPI.setIdentifier("JSR184");
                    iMIDPAPI.setType(MIDPAPIType.OPTIONAL);
                    iMIDPAPI.setName("Mobile 3D Graphics API for J2ME");
                    iMIDPAPI.setVersion(new Version("1.0"));
                } else if (iMIDPAPI.getIdentifier().equalsIgnoreCase("mmapi.jar")) {
                    iMIDPAPI.setIdentifier("MMAPI");
                    iMIDPAPI.setType(MIDPAPIType.OPTIONAL);
                    iMIDPAPI.setName("Mobile Media API");
                    iMIDPAPI.setVersion(new Version("1.0"));
                }
            }
            iDeviceClasspath.addEntry((ILibrary)iMIDPLibrary);
            ++n2;
        }
    }

    private IDevice createDevice(File file) {
        MpowerplayerDevice mpowerplayerDevice = new MpowerplayerDevice();
        mpowerplayerDevice.setBundle(MpowerplayerPlugin.getDefault().getBundle().getSymbolicName());
        mpowerplayerDevice.setClasspath(this.getDeviceClasspath(file));
        mpowerplayerDevice.setDebugServer(this.isDebugServer());
        mpowerplayerDevice.setDescription("Mpowerplayer Device");
        mpowerplayerDevice.setDeviceProperties(new Properties());
        mpowerplayerDevice.setGroupName("Mpowerplayer");
        mpowerplayerDevice.setName("Mpowerplayer");
        mpowerplayerDevice.setPreverifier(this.getPreverifier(file));
        mpowerplayerDevice.setProtectionDomains(new String[0]);
        mpowerplayerDevice.setLaunchCommandTemplate(this.getLaunchCommand());
        mpowerplayerDevice.setMppRoot(file.getParentFile());
        ISymbolSet iSymbolSet = MTJCore.getSymbolSetFactory().createSymbolSetFromDevice((IDevice)mpowerplayerDevice);
        iSymbolSet.setName(mpowerplayerDevice.getName());
        mpowerplayerDevice.setSymbolSet(iSymbolSet);
        Version version = new Version(1, 0, 0);
        ISDK iSDK = BasicSDK.getSDK((String)"Mpowerplayer", (Version)version);
        mpowerplayerDevice.setSDK(iSDK);
        ((BasicSDK)iSDK).addDevice((IDevice)mpowerplayerDevice);
        return mpowerplayerDevice;
    }

    private File findEmbeddedPreverifyExtecutable(File file) {
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                String string = file.getName();
                return file.isDirectory() || string.equals("preverify");
            }
        });
        File file2 = null;
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file3 = fileArray2[n2];
            if (!file3.isDirectory()) {
                file2 = file3;
                break;
            }
            file2 = this.findEmbeddedPreverifyExtecutable(file3);
            ++n2;
        }
        return file2;
    }

    private IDeviceClasspath getDeviceClasspath(File file) {
        IDeviceClasspath iDeviceClasspath = MTJCore.createNewDeviceClasspath();
        ILibraryImporter iLibraryImporter = MTJCore.getLibraryImporter((String)"org.eclipse.mtj.libraryimporter.uei");
        this.addMplayerDeviceLibraries(file, iDeviceClasspath, iLibraryImporter);
        return iDeviceClasspath;
    }

    protected URL getDevicePropertiesURL() {
        return MpowerplayerPlugin.getDefault().getBundle().getEntry(PROPS_FILE);
    }

    protected IPreverifier getPreverifier(File file) {
        File file2;
        File file3;
        IPreverifier iPreverifier = super.getPreverifier(file);
        if (osName.equals(MACOSX_OS_NAME) && (file3 = this.findEmbeddedPreverifyExtecutable(file2 = new File(String.valueOf(file.getParentFile().getPath()) + PLAYER_MACOSX_PREVERIFIER))) != null) {
            try {
                iPreverifier = MTJCore.createPreverifier((String)"org.eclipse.mtj.preverifier.standard", (Object)file3);
            }
            catch (CoreException coreException) {
                MTJLogger.log((int)2, (String)Messages.MpowerplayerDeviceImporter_preverifier_import_error, (Throwable)coreException);
            }
        }
        return iPreverifier;
    }
}

