/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util.xml;

import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;

public class MTJXMLHelper {
    protected static DocumentBuilderFactory fDOMFactory;
    protected static List<SoftReference<DocumentBuilder>> fDOMParserQueue;
    protected static int fDOMPoolLimit;
    protected static final int FMAXPOOLLIMIT = 1;
    protected static MTJXMLHelper fPinstance;
    protected static SAXParserFactory fSAXFactory;
    protected static List<SoftReference<SAXParser>> fSAXParserQueue;
    protected static int fSAXPoolLimit;

    public static int getDOMPoolLimit() {
        return fDOMPoolLimit;
    }

    public static int getSAXPoolLimit() {
        return fSAXPoolLimit;
    }

    public static String getWritableAttributeString(String string) {
        if (string == null) {
            return "";
        }
        string = string.trim();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\r': {
                    stringBuffer.append("&#x0D;");
                    break;
                }
                case '\n': {
                    stringBuffer.append("&#x0A;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String getWritableString(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static MTJXMLHelper Instance() throws FactoryConfigurationError {
        if (fPinstance == null) {
            fPinstance = new MTJXMLHelper();
        }
        return fPinstance;
    }

    public static void setDOMPoolLimit(int n) {
        fDOMPoolLimit = n;
    }

    public static void setSAXPoolLimit(int n) {
        fSAXPoolLimit = n;
    }

    protected MTJXMLHelper() throws FactoryConfigurationError {
        fSAXFactory = SAXParserFactory.newInstance();
        fDOMFactory = DocumentBuilderFactory.newInstance();
        fSAXParserQueue = Collections.synchronizedList(new LinkedList());
        fDOMParserQueue = Collections.synchronizedList(new LinkedList());
        fSAXPoolLimit = 1;
        fDOMPoolLimit = 1;
    }

    public synchronized DocumentBuilder getDefaultDOMParser() throws ParserConfigurationException {
        SoftReference<DocumentBuilder> softReference;
        DocumentBuilder documentBuilder = null;
        documentBuilder = fDOMParserQueue.isEmpty() ? fDOMFactory.newDocumentBuilder() : ((softReference = fDOMParserQueue.remove(0)).get() != null ? softReference.get() : fDOMFactory.newDocumentBuilder());
        return documentBuilder;
    }

    public synchronized SAXParser getDefaultSAXParser() throws ParserConfigurationException, SAXException {
        SoftReference<SAXParser> softReference;
        SAXParser sAXParser = null;
        sAXParser = fSAXParserQueue.isEmpty() ? fSAXFactory.newSAXParser() : ((softReference = fSAXParserQueue.remove(0)).get() != null ? softReference.get() : fSAXFactory.newSAXParser());
        return sAXParser;
    }

    public synchronized void recycleDOMParser(DocumentBuilder documentBuilder) {
        if (fDOMParserQueue.size() < fDOMPoolLimit) {
            SoftReference<DocumentBuilder> softReference = new SoftReference<DocumentBuilder>(documentBuilder);
            fDOMParserQueue.add(softReference);
        }
    }

    public synchronized void recycleSAXParser(SAXParser sAXParser) {
        if (fSAXParserQueue.size() < fSAXPoolLimit) {
            SoftReference<SAXParser> softReference = new SoftReference<SAXParser>(sAXParser);
            fSAXParserQueue.add(softReference);
        }
    }
}

