/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util.xml;

import org.eclipse.mtj.internal.core.util.xml.DocumentVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentAdapter {
    private Document document;

    public DocumentAdapter(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Document can not be null.");
        }
        this.document = document;
    }

    public void accept(DocumentVisitor documentVisitor) {
        Element element = this.document.getDocumentElement();
        documentVisitor.visitElement(element);
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() > 0) {
            this.accept(nodeList, documentVisitor);
        }
    }

    private void accept(NodeList nodeList, DocumentVisitor documentVisitor) {
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            switch (node.getNodeType()) {
                case 1: {
                    documentVisitor.visitElement((Element)node);
                }
            }
            NodeList nodeList2 = node.getChildNodes();
            if (nodeList2.getLength() > 0) {
                this.accept(nodeList2, documentVisitor);
            }
            ++n;
        }
    }
}

