/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.internal.core.util.IClasspathChangeListener;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class ClasspathChangeMonitor
implements IResourceChangeListener {
    private static ClasspathChangeMonitor instance;
    private Map<IMTJProject, List<IClasspathChangeListener>> map = new HashMap<IMTJProject, List<IClasspathChangeListener>>();

    public static ClasspathChangeMonitor getInstance() {
        if (instance == null) {
            instance = new ClasspathChangeMonitor();
        }
        return instance;
    }

    private ClasspathChangeMonitor() {
    }

    public void addClasspathChangeListener(IMTJProject iMTJProject, IClasspathChangeListener iClasspathChangeListener) {
        List<IClasspathChangeListener> list = this.map.get(iMTJProject);
        if (list == null) {
            list = new ArrayList<IClasspathChangeListener>();
            this.map.put(iMTJProject, list);
        }
        list.add(iClasspathChangeListener);
    }

    public void removeClasspathChangeListener(IMTJProject iMTJProject, IClasspathChangeListener iClasspathChangeListener) {
        List<IClasspathChangeListener> list = this.map.get(iMTJProject);
        if (list != null) {
            list.remove(iClasspathChangeListener);
        }
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        if (iResourceDelta == null) {
            return;
        }
        ClassPathVisitor classPathVisitor = new ClassPathVisitor();
        try {
            iResourceDelta.accept((IResourceDeltaVisitor)classPathVisitor);
        }
        catch (CoreException coreException) {
            MTJLogger.log(4, coreException);
        }
    }

    class ClassPathVisitor
    implements IResourceDeltaVisitor {
        ClassPathVisitor() {
        }

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            boolean bl = true;
            IResource iResource = iResourceDelta.getResource();
            try {
                IProject iProject;
                if (iResource.getProjectRelativePath().toString().equals(".classpath") && iResourceDelta.getKind() == 4 && (iProject = iResource.getProject()) != null && iProject.hasNature("org.eclipse.mtj.core.nature")) {
                    IMTJProject iMTJProject = MTJCore.geMTJProject(iProject);
                    List list = (List)ClasspathChangeMonitor.this.map.get(iMTJProject);
                    if (list != null) {
                        for (IClasspathChangeListener iClasspathChangeListener : list) {
                            iClasspathChangeListener.classpathChanged();
                        }
                    }
                    bl = false;
                }
            }
            catch (CoreException coreException) {
                MTJLogger.log(4, coreException);
            }
            return bl;
        }
    }
}

