/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text.l10n;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.xml.sax.SAXParseException;

public class L10nMarkerManager {
    public static final String MARKER_ID = "org.eclipse.mtj.core.problem";

    private void createMarker(IFile iFile, int n, String string, int n2, boolean bl) throws CoreException {
        if (bl) {
            this.clearMarkers(iFile, 2);
        }
        IMarker iMarker = iFile.createMarker(MARKER_ID);
        iMarker.setAttribute("severity", n);
        iMarker.setAttribute("message", (Object)string);
        iMarker.setAttribute("lineNumber", n2);
    }

    public void createMarker(IFile iFile, L10nModel l10nModel) throws CoreException {
        if (l10nModel.getStatus().getException() != null) {
            this.createMarker(iFile, 2, l10nModel.getStatus().getMessage(), ((SAXParseException)l10nModel.getStatus().getException()).getLineNumber(), true);
        }
    }

    public void createMarker(IFile iFile, SAXParseException sAXParseException) throws CoreException {
        if (sAXParseException != null) {
            this.createMarker(iFile, 2, sAXParseException.getMessage(), sAXParseException.getLineNumber(), true);
        }
    }

    public void createMarker(IFile iFile, int n, String string, boolean bl) throws CoreException {
        this.createMarker(iFile, 2, string, n, bl);
    }

    public void clearMarkers(IFile iFile, int n) throws CoreException {
        IMarker[] iMarkerArray = iFile.findMarkers(MARKER_ID, true, 2);
        if (iMarkerArray.length > 0) {
            int n2 = 0;
            while (n2 < iMarkerArray.length) {
                if (iMarkerArray[n2].getAttribute("severity").equals(n)) {
                    iMarkerArray[n2].delete();
                }
                ++n2;
            }
        }
    }

    public void addWarningMarker(IFile iFile, int n, String string) throws CoreException {
        this.clearWarningMarkers(iFile);
        this.createMarker(iFile, 1, string, n, false);
    }

    public void clearWarningMarkers(IFile iFile) throws CoreException {
        this.clearMarkers(iFile, 1);
    }
}

