/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text.l10n;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.internal.core.MTJPluginSchemas;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nMarkerError;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L10nLocales
extends L10nObject {
    private static final long serialVersionUID = 1L;
    private L10nLocale defaultLocale;
    private Schema schema;
    private Vector<L10nLocale> localeList;

    public L10nLocales(L10nModel l10nModel) {
        super(l10nModel, "locales");
        this.setInTheModel(true);
        this.localeList = new Vector();
    }

    @Override
    public void addChild(L10nObject l10nObject) {
        this.addChildNode((IDocumentElementNode)l10nObject, true);
    }

    @Override
    public void addChild(L10nObject l10nObject, L10nObject l10nObject2, boolean bl) {
        int n = this.indexOf(l10nObject2);
        if (!bl) {
            ++n;
        }
        this.addChildNode(l10nObject, n, true);
    }

    @Override
    public boolean canBeParent() {
        return true;
    }

    public String getDestination() {
        return this.getXMLAttributeValue("destination");
    }

    public L10nLocale getDefaultLocale() {
        String string = this.getXMLAttributeValue("default-locale");
        if (string == null || string.length() == 0) {
            this.defaultLocale = null;
        } else {
            IDocumentElementNode[] iDocumentElementNodeArray = this.getChildNodes();
            boolean bl = false;
            IDocumentElementNode[] iDocumentElementNodeArray2 = iDocumentElementNodeArray;
            int n = iDocumentElementNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                L10nLocale l10nLocale;
                IDocumentElementNode iDocumentElementNode = iDocumentElementNodeArray2[n2];
                if (iDocumentElementNode instanceof L10nLocale && (l10nLocale = (L10nLocale)iDocumentElementNode).getName().equals(string)) {
                    this.defaultLocale = l10nLocale;
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                this.defaultLocale = null;
                this.setXMLAttribute("default-locale", "");
            }
        }
        return this.defaultLocale;
    }

    public L10nLocale createlLocale() {
        L10nLocale l10nLocale = null;
        l10nLocale = new L10nLocale(this.getModel());
        this.localeList.add(l10nLocale);
        return l10nLocale;
    }

    public L10nLocale getLocale(IDocumentElementNode iDocumentElementNode) {
        L10nLocale l10nLocale = null;
        int n = 0;
        while (n < this.localeList.size()) {
            if (this.localeList.get(n).equals(iDocumentElementNode)) {
                l10nLocale = this.localeList.get(n);
            }
            ++n;
        }
        return l10nLocale;
    }

    @Override
    public String getName() {
        return "Locales";
    }

    public String getPackage() {
        String string = this.getXMLAttributeValue("package");
        return string == null ? "" : string;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    public void moveChild(L10nObject l10nObject, int n) {
        this.moveChildNode(l10nObject, n, true);
    }

    public void removeChild(L10nObject l10nObject) {
        this.removeChildNode(l10nObject, true);
    }

    public void setDestination(String string) {
        this.setXMLAttribute("destination", string);
    }

    public void setPackage(String string) {
        this.setXMLAttribute("package", string);
    }

    public void setDefaultLocale(L10nLocale l10nLocale) {
        String string = null;
        if (l10nLocale != null) {
            string = l10nLocale.getName();
        }
        this.setXMLAttribute("default-locale", string);
        this.defaultLocale = l10nLocale;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validate() {
        if (!this.validateLocalesSchema()) {
            IDocumentElementNode[] iDocumentElementNodeArray = this.getChildNodes();
            int n = 0;
            while (n < iDocumentElementNodeArray.length) {
                block14: {
                    L10nLocale l10nLocale;
                    try {
                        l10nLocale = (L10nLocale)iDocumentElementNodeArray[n];
                    }
                    catch (Exception exception) {
                        break block14;
                    }
                    l10nLocale.validate();
                }
                ++n;
            }
        } else {
            void l10nLocale;
            IDocumentElementNode[] iDocumentElementNodeArray = this.getChildNodes();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            boolean n = false;
            while (l10nLocale < iDocumentElementNodeArray.length) {
                block15: {
                    L10nLocale l10nLocale2;
                    try {
                        l10nLocale2 = (L10nLocale)iDocumentElementNodeArray[l10nLocale];
                    }
                    catch (Exception exception) {
                        break block15;
                    }
                    l10nLocale2.validate();
                    String string = l10nLocale2.getName();
                    if (!arrayList.contains(l10nLocale2)) {
                        boolean bl = false;
                        int n2 = 0;
                        while (n2 < iDocumentElementNodeArray.length) {
                            if (iDocumentElementNodeArray[n2] instanceof L10nLocale) {
                                L10nLocale l10nLocale3 = (L10nLocale)iDocumentElementNodeArray[n2];
                                String string2 = l10nLocale3.getLocaleName();
                                if (n2 != l10nLocale && string.equalsIgnoreCase(string2)) {
                                    arrayList.add(l10nLocale3);
                                    bl = true;
                                }
                            }
                            ++n2;
                        }
                        if (bl) {
                            arrayList.add(l10nLocale2);
                        }
                    }
                }
                ++l10nLocale;
            }
            for (L10nLocale l10nLocale4 : arrayList) {
                l10nLocale4.setStatus((IStatus)new Status(4, "org.eclipse.mtj.core", Messages.L10nLocales_duplicatedLocale));
            }
        }
    }

    public Vector<L10nMarkerError> getMarkerErrors() {
        IDocumentElementNode[] iDocumentElementNodeArray = this.getChildNodes();
        Vector<L10nMarkerError> vector = new Vector<L10nMarkerError>();
        if (!this.getStatus().isOK()) {
            if (this.getStatus().getException() instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)this.getStatus().getException();
                L10nMarkerError l10nMarkerError = new L10nMarkerError(sAXParseException.getMessage(), sAXParseException.getLineNumber());
                vector.add(l10nMarkerError);
            } else {
                int n = -1;
                try {
                    int n2 = this.getModel().getDocument().getLineOfOffset(this.getOffset());
                    int n3 = this.getLength();
                    n = n2 + this.getModel().getDocument().getNumberOfLines(this.getOffset(), n3);
                }
                catch (BadLocationException badLocationException) {
                    return new Vector<L10nMarkerError>();
                }
                L10nMarkerError l10nMarkerError = new L10nMarkerError(this.getStatus().getMessage(), n);
                vector.add(l10nMarkerError);
            }
        } else {
            int n = 0;
            while (n < iDocumentElementNodeArray.length) {
                block16: {
                    try {
                        L10nLocale l10nLocale;
                        try {
                            l10nLocale = (L10nLocale)iDocumentElementNodeArray[n];
                        }
                        catch (Exception exception) {
                            break block16;
                        }
                        if (l10nLocale.getStatus().isOK()) {
                            Vector<L10nMarkerError> vector2 = l10nLocale.getMarkerErrors();
                            if (vector2.size() > 0) {
                                return vector2;
                            }
                        } else {
                            int n4 = -1;
                            try {
                                int n5 = this.getModel().getDocument().getLineOfOffset(l10nLocale.getOffset());
                                int n6 = l10nLocale.getLength();
                                n4 = n5 + this.getModel().getDocument().getNumberOfLines(l10nLocale.getOffset(), n6);
                                L10nMarkerError l10nMarkerError = new L10nMarkerError(l10nLocale.getStatus().getMessage(), n4);
                                vector.add(l10nMarkerError);
                            }
                            catch (BadLocationException badLocationException) {}
                        }
                    }
                    catch (Exception exception) {}
                }
                ++n;
            }
        }
        return vector;
    }

    public int getLocalesLine() {
        int n = -1;
        try {
            n = this.getModel().getDocument().getLineOfOffset(this.getOffset());
        }
        catch (BadLocationException badLocationException) {
            return n;
        }
        return n;
    }

    private boolean validateLocalesSchema() {
        boolean bl = true;
        IDocument iDocument = this.getModel().getDocument();
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(iDocument.get().getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bl = false;
        }
        try {
            String string = "http://www.w3.org/2001/XMLSchema";
            SchemaFactory schemaFactory = SchemaFactory.newInstance(string);
            if (this.schema == null) {
                this.schema = schemaFactory.newSchema(MTJPluginSchemas.getInstance().create("locales.xsd"));
            }
            Validator validator = this.schema.newValidator();
            validator.validate(new StreamSource(bufferedInputStream));
            Status status = new Status(0, "org.eclipse.mtj.core", null);
            this.setStatus((IStatus)status);
        }
        catch (Exception exception) {
            Status status = new Status(4, "org.eclipse.mtj.core", exception.getMessage(), (Throwable)exception);
            this.setStatus((IStatus)status);
            bl = false;
        }
        return bl;
    }

    @Override
    public IDocumentElementNode removeChildNode(IDocumentElementNode iDocumentElementNode, boolean bl) {
        this.localeList.remove(iDocumentElementNode);
        return super.removeChildNode(iDocumentElementNode, bl);
    }

    public L10nLocale getLocale(String string) {
        IDocumentElementNode[] iDocumentElementNodeArray;
        L10nLocale l10nLocale = null;
        IDocumentElementNode[] iDocumentElementNodeArray2 = iDocumentElementNodeArray = this.getChildNodes();
        int n = iDocumentElementNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            L10nLocale l10nLocale2;
            IDocumentElementNode iDocumentElementNode = iDocumentElementNodeArray2[n2];
            if (iDocumentElementNode instanceof L10nLocale && (l10nLocale2 = (L10nLocale)iDocumentElementNode).getLocaleName().equals(string)) {
                l10nLocale = l10nLocale2;
                break;
            }
            ++n2;
        }
        return l10nLocale;
    }
}

