/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.mtj.internal.core.text.IDocumentAttributeNode;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.IDocumentTextNode;
import org.eclipse.mtj.internal.core.util.xml.MTJXMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DocumentHandler
extends DefaultHandler {
    private IDocumentElementNode fLastError;
    private Locator fLocator;
    private boolean fReconciling;
    protected Stack<IDocumentElementNode> fDocumentNodeStack = new Stack();
    protected int fHighestOffset = 0;

    public DocumentHandler(boolean bl) {
        this.fReconciling = bl;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.fReconciling || this.fDocumentNodeStack.isEmpty()) {
            return;
        }
        IDocumentElementNode iDocumentElementNode = this.fDocumentNodeStack.peek();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cArray, n, n2);
        this.getDocumentTextNode(stringBuffer.toString(), iDocumentElementNode);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.fDocumentNodeStack.isEmpty()) {
            return;
        }
        IDocumentElementNode iDocumentElementNode = this.fDocumentNodeStack.pop();
        try {
            iDocumentElementNode.setLength(this.getElementLength(iDocumentElementNode, this.fLocator.getLineNumber() - 1, this.fLocator.getColumnNumber()));
            this.setTextNodeOffset(iDocumentElementNode);
        }
        catch (BadLocationException badLocationException) {}
        this.removeOrphanElements(iDocumentElementNode);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.generateErrorElementHierarchy();
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.generateErrorElementHierarchy();
    }

    public IDocumentElementNode getLastErrorNode() {
        return this.fLastError;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        return new InputSource(new StringReader(""));
    }

    public void setDocumentLocator(Locator locator) {
        this.fLocator = locator;
    }

    public void startDocument() throws SAXException {
        this.fDocumentNodeStack.clear();
        this.fHighestOffset = 0;
        this.fLastError = null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        IDocumentElementNode[] iDocumentElementNodeArray;
        int n;
        IDocumentElementNode iDocumentElementNode = this.getLastParsedDocumentNode();
        IDocumentElementNode iDocumentElementNode2 = this.getDocumentNode(string3, iDocumentElementNode);
        try {
            n = this.getStartOffset(string3);
            iDocumentElementNode2.setOffset(n);
            iDocumentElementNodeArray = this.getDocument();
            int n2 = iDocumentElementNodeArray.getLineOfOffset(n);
            iDocumentElementNode2.setLineIndent(iDocumentElementNode2.getOffset() - iDocumentElementNodeArray.getLineOffset(n2));
            int n3 = 0;
            while (n3 < attributes.getLength()) {
                String string4;
                String string5 = attributes.getQName(n3);
                IDocumentAttributeNode iDocumentAttributeNode = this.getDocumentAttribute(string5, string4 = attributes.getValue(n3), iDocumentElementNode2);
                if (iDocumentAttributeNode != null) {
                    IRegion iRegion = this.getAttributeRegion(string5, string4, n);
                    if (iRegion == null) {
                        string4 = MTJXMLHelper.getWritableString(string4);
                        iRegion = this.getAttributeRegion(string5, string4, n);
                    }
                    if (iRegion != null) {
                        iDocumentAttributeNode.setNameOffset(iRegion.getOffset());
                        iDocumentAttributeNode.setNameLength(string5.length());
                        iDocumentAttributeNode.setValueOffset(iRegion.getOffset() + iRegion.getLength() - 1 - string4.length());
                        iDocumentAttributeNode.setValueLength(string4.length());
                    }
                    iDocumentElementNode2.setXMLAttribute(iDocumentAttributeNode);
                }
                ++n3;
            }
            this.removeOrphanAttributes(iDocumentElementNode2);
        }
        catch (BadLocationException badLocationException) {}
        if (iDocumentElementNode != null && iDocumentElementNode2 != null && iDocumentElementNode2.getParentNode() == null) {
            if (this.fReconciling) {
                n = 0;
                iDocumentElementNodeArray = iDocumentElementNode.getChildNodes();
                while (n < iDocumentElementNodeArray.length) {
                    if (iDocumentElementNodeArray[n].getOffset() == -1) break;
                    ++n;
                }
                iDocumentElementNode.addChildNode(iDocumentElementNode2, n);
            } else {
                iDocumentElementNode.addChildNode(iDocumentElementNode2);
            }
        }
        iDocumentElementNode2.validate();
        this.fDocumentNodeStack.push(iDocumentElementNode2);
    }

    private void generateErrorElementHierarchy() {
        while (!this.fDocumentNodeStack.isEmpty()) {
            IDocumentElementNode iDocumentElementNode = this.fDocumentNodeStack.pop();
            iDocumentElementNode.setIsErrorNode(true);
            this.removeOrphanAttributes(iDocumentElementNode);
            this.removeOrphanElements(iDocumentElementNode);
            if (this.fLastError != null) continue;
            this.fLastError = iDocumentElementNode;
        }
    }

    private IRegion getAttributeRegion(String string, String string2, int n) throws BadLocationException {
        FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter(this.getDocument());
        IRegion iRegion = findReplaceDocumentAdapter.find(n, String.valueOf(string) + "\\s*=\\s*\"", true, true, false, true);
        if (iRegion != null && this.getDocument().get(iRegion.getOffset() + iRegion.getLength(), string2.length()).equals(string2)) {
            return new Region(iRegion.getOffset(), iRegion.getLength() + string2.length() + 1);
        }
        return null;
    }

    private int getElementLength(IDocumentElementNode iDocumentElementNode, int n, int n2) throws BadLocationException {
        int n3;
        int n4 = iDocumentElementNode.getOffset();
        IDocument iDocument = this.getDocument();
        String string = iDocument.get(n3 = Math.max(iDocument.getLineOffset(n), iDocumentElementNode.getOffset()), (n2 = iDocument.getLineLength(n)) - n3 + iDocument.getLineOffset(n));
        int n5 = string.indexOf("</" + iDocumentElementNode.getXMLTagName() + ">");
        n4 = n5 == -1 ? ((n5 = string.indexOf(">")) == -1 ? n2 : n5 + 1) : n5 + iDocumentElementNode.getXMLTagName().length() + 3;
        return n3 + n4 - iDocumentElementNode.getOffset();
    }

    private int getStartOffset(String string) throws BadLocationException {
        int n;
        Object object;
        int n2;
        int n3 = this.fLocator.getLineNumber();
        int n4 = this.fLocator.getColumnNumber();
        IDocument iDocument = this.getDocument();
        if (n4 < 0) {
            n4 = iDocument.getLineLength(n3);
        }
        if (n3 < iDocument.getNumberOfLines()) {
            n2 = iDocument.getLineOffset(n3);
        } else {
            n3 = iDocument.getNumberOfLines() - 1;
            object = iDocument.getLineInformation(n3);
            n2 = object.getOffset() + object.getLength();
        }
        object = iDocument.get(this.fHighestOffset + 1, n2 - this.fHighestOffset - 1);
        ArrayList<Position> arrayList = new ArrayList<Position>();
        int n5 = 0;
        while (n5 < ((String)object).length()) {
            if ((n5 = ((String)object).indexOf("<!--", n5)) == -1 || (n = ((String)object).indexOf("-->", n5)) == -1) break;
            arrayList.add(new Position(n5, n - n5));
            n5 = n + 1;
        }
        n5 = 0;
        while (n5 < ((String)object).length()) {
            n5 = ((String)object).indexOf("<" + string, n5);
            if (n5 == -1) break;
            n = 1;
            int n6 = 0;
            while (n6 < arrayList.size()) {
                Position position = (Position)arrayList.get(n6);
                if (position.includes(n5)) {
                    n = 0;
                    break;
                }
                ++n6;
            }
            if (n != 0) break;
            ++n5;
        }
        if (n5 > -1) {
            this.fHighestOffset += n5 + 1;
        }
        return this.fHighestOffset;
    }

    private void removeOrphanAttributes(IDocumentElementNode iDocumentElementNode) {
        if (this.fReconciling) {
            IDocumentAttributeNode[] iDocumentAttributeNodeArray;
            IDocumentAttributeNode[] iDocumentAttributeNodeArray2 = iDocumentAttributeNodeArray = iDocumentElementNode.getNodeAttributes();
            int n = iDocumentAttributeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDocumentAttributeNode iDocumentAttributeNode = iDocumentAttributeNodeArray2[n2];
                if (iDocumentAttributeNode.getNameOffset() == -1) {
                    iDocumentElementNode.removeDocumentAttribute(iDocumentAttributeNode);
                }
                ++n2;
            }
        }
    }

    private void removeOrphanElements(IDocumentElementNode iDocumentElementNode) {
        if (this.fReconciling) {
            IDocumentElementNode[] iDocumentElementNodeArray;
            IDocumentElementNode[] iDocumentElementNodeArray2 = iDocumentElementNodeArray = iDocumentElementNode.getChildNodes();
            int n = iDocumentElementNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDocumentElementNode iDocumentElementNode2 = iDocumentElementNodeArray2[n2];
                if (iDocumentElementNode2.getOffset() == -1) {
                    iDocumentElementNode.removeChildNode(iDocumentElementNode2);
                }
                ++n2;
            }
        }
    }

    protected abstract IDocument getDocument();

    protected abstract IDocumentAttributeNode getDocumentAttribute(String var1, String var2, IDocumentElementNode var3);

    protected abstract IDocumentElementNode getDocumentNode(String var1, IDocumentElementNode var2);

    protected abstract IDocumentTextNode getDocumentTextNode(String var1, IDocumentElementNode var2);

    protected IDocumentElementNode getLastParsedDocumentNode() {
        if (this.fDocumentNodeStack.isEmpty()) {
            return null;
        }
        return this.fDocumentNodeStack.peek();
    }

    protected boolean isReconciling() {
        return this.fReconciling;
    }

    /*
     * Unable to fully structure code
     */
    protected void setTextNodeOffset(IDocumentElementNode var1_1) throws BadLocationException {
        block4: {
            var2_2 = var1_1.getTextNode();
            if (var2_2 == null || var2_2.getText() == null) break block4;
            if (var2_2.getText().trim().length() == 0) {
                var1_1.removeTextNode();
                return;
            }
            var3_3 = this.getDocument();
            var4_4 = var3_3.get(var1_1.getOffset(), var1_1.getLength());
            var5_5 = var4_4.indexOf(62) + 1;
            var6_6 = var4_4.lastIndexOf(60) - 1;
            if (var5_5 < 0 || var5_5 >= var4_4.length()) {
                return;
            }
            if (var6_6 >= 0 && var6_6 < var4_4.length()) ** GOTO lbl15
            return;
lbl-1000:
            // 1 sources

            {
                ++var5_5;
lbl15:
                // 2 sources

                ** while (Character.isWhitespace((char)var4_4.charAt((int)var5_5)))
            }
lbl16:
            // 2 sources

            while (Character.isWhitespace(var4_4.charAt(var6_6))) {
                --var6_6;
            }
            var2_2.setOffset(var1_1.getOffset() + var5_5);
            var2_2.setLength(var6_6 - var5_5 + 1);
            var2_2.setText(var2_2.getText().trim());
        }
    }
}

