/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.symbol;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.symbol.ISymbol;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.core.symbol.ISymbolSetFactory;
import org.eclipse.mtj.internal.core.symbol.Symbol;
import org.eclipse.mtj.internal.core.symbol.SymbolSet;
import org.eclipse.mtj.internal.core.symbol.SymbolUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolSetFactory
implements ISymbolSetFactory {
    public static final String J2MEPOLISH_FILENAME_XML_DEVICES = "devices.xml";
    public static final String J2MEPOLISH_FILENAME_XML_GROUPS = "groups.xml";
    private static final SymbolSetFactory instance = new SymbolSetFactory();

    public static ISymbolSetFactory getInstance() {
        return instance;
    }

    @Override
    public ISymbol createSymbol(String string, String string2) {
        Symbol symbol = new Symbol(string, string2);
        return symbol;
    }

    @Override
    public ISymbolSet createSymbolSet(String string) {
        SymbolSet symbolSet = new SymbolSet();
        symbolSet.setName(string);
        return symbolSet;
    }

    @Override
    public List<ISymbolSet> createSymbolSetFromDataBase(String string, IPath iPath, IProgressMonitor iProgressMonitor) throws IOException {
        List<ISymbolSet> list = null;
        if (string.equals("org.eclipse.mtj.davicedb.j2mepolish.antennajar")) {
            list = this.handleAntennaJAR(iProgressMonitor, iPath);
        } else if (string.equals("org.eclipse.mtj.davicedb.j2mepolish.file")) {
            list = this.handleFiles(iProgressMonitor, iPath);
        }
        return list;
    }

    @Override
    public ISymbolSet createSymbolSetFromDevice(IDevice iDevice) {
        ISymbolSet iSymbolSet = SymbolUtils.createSymbolSet(iDevice);
        return iSymbolSet;
    }

    @Override
    public ISymbolSet createSymbolSetFromProperties(Properties properties) {
        ISymbolSet iSymbolSet = SymbolUtils.createSymbolSet(properties);
        return iSymbolSet;
    }

    private List<ISymbolSet> handleAntennaJAR(IProgressMonitor iProgressMonitor, IPath iPath) throws IOException {
        InputStream inputStream;
        InputStream inputStream2;
        JarFile jarFile;
        List<ISymbolSet> list;
        block18: {
            list = null;
            jarFile = null;
            inputStream2 = null;
            inputStream = null;
            try {
                jarFile = new JarFile(iPath.toFile());
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    if (jarEntry.getName().toLowerCase().equals(J2MEPOLISH_FILENAME_XML_DEVICES)) {
                        inputStream2 = jarFile.getInputStream(jarEntry);
                    }
                    if (!jarEntry.getName().toLowerCase().equals(J2MEPOLISH_FILENAME_XML_GROUPS)) continue;
                    inputStream = jarFile.getInputStream(jarEntry);
                }
                if (inputStream2 == null || inputStream == null) break block18;
                try {
                    list = SymbolUtils.importFromJ2MEPolishFormat(iProgressMonitor, inputStream2, inputStream);
                }
                catch (Exception exception) {
                    throw new IOException();
                }
            }
            catch (Throwable throwable) {
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
            if (inputStream2 != null) {
                inputStream2.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {}
        return list;
    }

    private List<ISymbolSet> handleFiles(IProgressMonitor iProgressMonitor, IPath iPath) throws IOException {
        List<ISymbolSet> list = null;
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        try {
            try {
                inputStream = new FileInputStream(new File(iPath + File.separator + J2MEPOLISH_FILENAME_XML_DEVICES));
                inputStream2 = new FileInputStream(new File(iPath + File.separator + J2MEPOLISH_FILENAME_XML_GROUPS));
                list = SymbolUtils.importFromJ2MEPolishFormat(iProgressMonitor, inputStream, inputStream2);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (PersistenceException persistenceException) {
                throw new IOException();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new IOException();
            }
            catch (SAXException sAXException) {
                throw new IOException();
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (inputStream2 != null) {
                inputStream2.close();
            }
        }
        return list;
    }
}

