/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.statemachine;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.statemachine.AbstractStateMachineEvent;
import org.eclipse.mtj.internal.core.statemachine.AbstractStateTransition;

public abstract class AbstractState {
    private List<AbstractStateTransition> transitions = new ArrayList<AbstractStateTransition>();
    private List<AbstractState> childStates;
    private AbstractState parent;
    private AbstractState intialChild;

    public AbstractState(AbstractState abstractState) {
        this.parent = abstractState;
        if (this.parent != null) {
            this.parent.addChildState(this);
        }
    }

    public final void addTransition(AbstractStateTransition abstractStateTransition) {
        if (abstractStateTransition == null) {
            throw new IllegalArgumentException(Messages.AbstractState_transitionNotNull);
        }
        if (abstractStateTransition.getSource() == null) {
            throw new IllegalArgumentException(Messages.AbstractState_noSourceState);
        }
        if (abstractStateTransition.getTarget() == null) {
            throw new IllegalArgumentException(Messages.AbstractState_noTargetState);
        }
        if (abstractStateTransition.getSource() != this) {
            throw new IllegalArgumentException(Messages.AbstractState_invalidSourceState);
        }
        if (!this.transitions.contains(abstractStateTransition)) {
            this.transitions.add(abstractStateTransition);
        }
    }

    public final void removeTransition(AbstractStateTransition abstractStateTransition) {
        this.transitions.remove(abstractStateTransition);
    }

    public final void setInitialState(AbstractState abstractState) {
        if (abstractState == null) {
            throw new IllegalArgumentException(Messages.AbstractState_stateNotNull);
        }
        if (abstractState.getParent() != this) {
            throw new IllegalArgumentException(Messages.AbstractState_invalidInitialState);
        }
        this.intialChild = abstractState;
    }

    public final AbstractStateTransition[] getTransitions() {
        return this.transitions.toArray(new AbstractStateTransition[this.transitions.size()]);
    }

    protected abstract void onEnter();

    protected abstract void onExit();

    final synchronized void addChildState(AbstractState abstractState) {
        if (this.childStates == null) {
            this.childStates = new ArrayList<AbstractState>();
        }
        this.childStates.add(abstractState);
    }

    final AbstractState getParent() {
        return this.parent;
    }

    final synchronized AbstractState postEvent(AbstractStateMachineEvent abstractStateMachineEvent) {
        AbstractStateTransition abstractStateTransition;
        AbstractStateTransition[] abstractStateTransitionArray;
        AbstractState abstractState = null;
        ArrayList<AbstractStateTransition> arrayList = new ArrayList<AbstractStateTransition>();
        AbstractStateTransition[] abstractStateTransitionArray2 = abstractStateTransitionArray = this.getTransitions();
        int n = abstractStateTransitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            abstractStateTransition = abstractStateTransitionArray2[n2];
            if (abstractStateTransition.isTransitionReady(abstractStateMachineEvent)) {
                arrayList.add(abstractStateTransition);
            }
            ++n2;
        }
        if (!arrayList.isEmpty()) {
            if (arrayList.size() > 1) {
                throw new IllegalStateException(Messages.AbstractState_conflictingTransitions);
            }
            abstractStateTransition = (AbstractStateTransition)arrayList.get(0);
            abstractState = abstractStateTransition.getTarget();
            abstractStateTransition.onTransition();
        }
        return abstractState;
    }

    final void onEnterState() {
        this.onEnter();
        if (this.intialChild != null) {
            this.intialChild.onEnterState();
        }
    }

    final void onExitState() {
        this.onExit();
        if (this.intialChild != null) {
            this.intialChild.onExitState();
        }
    }
}

