/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device.midp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.mtj.core.sdk.device.IAPI;
import org.eclipse.mtj.core.sdk.device.midp.MIDPAPIType;
import org.eclipse.mtj.internal.core.sdk.device.midp.MIDPAPI;
import org.eclipse.mtj.internal.core.sdk.device.midp.UEIAPIManifestAttributes;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIRegistry {
    public static List<IAPI> getAPIs(File file) {
        Object object;
        HashMap<String, Object> hashMap;
        block16: {
            hashMap = new HashMap<String, Object>();
            JarFile jarFile = null;
            try {
                try {
                    jarFile = new JarFile(file);
                    if (jarFile != null && (object = APIRegistry.createAPIFromManifest(jarFile)) != null) {
                        hashMap.put(object.toString(), object);
                    }
                }
                catch (IOException iOException) {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (hashMap.size() == 0) {
            object = APIRegistry.createUnknownAPI(file);
            hashMap.put(object.getIdentifier(), object);
        }
        object = new ArrayList(hashMap.values());
        return object;
    }

    private static IAPI createAPIFromManifest(JarFile jarFile) throws IOException {
        Attributes attributes;
        String string;
        MIDPAPI mIDPAPI = null;
        Manifest manifest = jarFile.getManifest();
        if (manifest != null && (string = (attributes = manifest.getMainAttributes()).getValue(UEIAPIManifestAttributes.API.toString())) != null) {
            mIDPAPI = new MIDPAPI();
            mIDPAPI.setIdentifier(string);
            mIDPAPI.setName(attributes.getValue(UEIAPIManifestAttributes.API_NAME.toString()));
            mIDPAPI.setType(APIRegistry.getTypeFromManifest(attributes));
            mIDPAPI.setVersion(APIRegistry.getVersionFromManifest(attributes));
        }
        return mIDPAPI;
    }

    private static IAPI createUnknownAPI(File file) {
        MIDPAPI mIDPAPI = new MIDPAPI();
        mIDPAPI.setIdentifier(file.getName());
        mIDPAPI.setName("Unknown Library");
        mIDPAPI.setType(MIDPAPIType.UNKNOWN);
        mIDPAPI.setVersion(new Version("1.0"));
        return mIDPAPI;
    }

    private static MIDPAPIType getTypeFromManifest(Attributes attributes) {
        MIDPAPIType mIDPAPIType = MIDPAPIType.UNKNOWN;
        String string = attributes.getValue(UEIAPIManifestAttributes.API_TYPE.toString());
        if (string == null || string.equalsIgnoreCase(MIDPAPIType.OPTIONAL.toString())) {
            mIDPAPIType = MIDPAPIType.OPTIONAL;
        } else if (string.equalsIgnoreCase(MIDPAPIType.PROFILE.toString())) {
            mIDPAPIType = MIDPAPIType.PROFILE;
        } else if (string.equalsIgnoreCase(MIDPAPIType.CONFIGURATION.toString())) {
            mIDPAPIType = MIDPAPIType.CONFIGURATION;
        }
        return mIDPAPIType;
    }

    private static Version getVersionFromManifest(Attributes attributes) {
        Version version = null;
        String string = attributes.getValue(UEIAPIManifestAttributes.API_VERSION.toString());
        version = string != null ? new Version(string) : new Version("0.0.0");
        return version;
    }

    private APIRegistry() {
    }
}

