/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.core.sdk.ISDK;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSDK
implements ISDK {
    private static final HashMap<String, ISDK> sdks = new HashMap();
    private String name;
    private Version version;
    private List<IDevice> deviceList;

    public static ISDK getSDK(String string, Version version) {
        String string2 = String.valueOf(string) + "_" + version;
        ISDK iSDK = sdks.get(string2);
        if (iSDK == null) {
            iSDK = new BasicSDK(string, version);
            sdks.put(string2, iSDK);
        }
        return iSDK;
    }

    public BasicSDK(String string, Version version) {
        this.name = string;
        this.version = version;
        this.deviceList = new ArrayList<IDevice>();
    }

    public void addDevice(IDevice iDevice) {
        this.deviceList.add(iDevice);
    }

    @Override
    public String getDescription() {
        return this.name;
    }

    @Override
    public List<IDevice> getDeviceList() throws CoreException {
        return this.deviceList;
    }

    @Override
    public String getIdentifier() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public boolean deleteDevice(IDevice iDevice) {
        return this.deviceList.remove(iDevice);
    }
}

