/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.preverifier;

import org.eclipse.mtj.core.build.preverifier.IPreverificationError;
import org.eclipse.mtj.internal.core.build.preverifier.IClassErrorInformation;
import org.eclipse.mtj.internal.core.build.preverifier.IPreverificationErrorLocation;
import org.eclipse.mtj.internal.core.build.preverifier.PreverificationErrorType;

public class PreverificationUtils {
    public static String getErrorText(IPreverificationError iPreverificationError) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = iPreverificationError.getDetail();
        if (string != null && string.length() > 0) {
            stringBuffer.append(string);
        } else {
            PreverificationUtils.appendErrorInformation(stringBuffer, iPreverificationError);
        }
        return stringBuffer.toString();
    }

    private static void appendErrorInformation(StringBuffer stringBuffer, IPreverificationError iPreverificationError) {
        PreverificationUtils.appendErrorTypeInformation(stringBuffer, iPreverificationError);
        if (iPreverificationError.getType() != PreverificationErrorType.FINALIZERS) {
            PreverificationUtils.appendErrorLocationInformation(stringBuffer, iPreverificationError);
        }
    }

    private static void appendErrorLocationInformation(StringBuffer stringBuffer, IPreverificationError iPreverificationError) {
        IClassErrorInformation iClassErrorInformation = ((IPreverificationErrorLocation)iPreverificationError.getLocation()).getClassInformation();
        switch (((IPreverificationErrorLocation)iPreverificationError.getLocation()).getLocationType().getTypeCode()) {
            case 0: {
                stringBuffer.append(" in class ").append(iClassErrorInformation.getName()).append(" or superclass");
            }
        }
    }

    private static void appendErrorTypeInformation(StringBuffer stringBuffer, IPreverificationError iPreverificationError) {
        switch (((PreverificationErrorType)iPreverificationError.getType()).getErrorCode()) {
            case 3: {
                stringBuffer.append("Finalizers not allowed");
                break;
            }
            case 2: {
                stringBuffer.append("Floating point not allowed");
                break;
            }
            case 4: {
                stringBuffer.append("Missing type");
                break;
            }
            case 1: {
                stringBuffer.append("Native method implementations not allowed");
                break;
            }
            case 5: {
                stringBuffer.append("Unknown error during preverification");
            }
        }
    }

    private PreverificationUtils() {
    }
}

