/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFSResourceImpl.java,v 1.1 2007/03/18 08:10:12 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfbase.impl;

import java.util.Collection;
import java.util.ArrayList;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.eodm.exceptions.UnsupportedViewTypeException;
import org.eclipse.eodm.rdf.rdfbase.PlainLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfbase.RDFStatement;
import org.eclipse.eodm.rdf.rdfbase.URIReference;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;
import org.eclipse.eodm.rdf.rdfs.RDFSClass;
import org.eclipse.eodm.rdf.rdfs.util.RDFSPackage;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>RDFS Resource</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFSResourceImpl#getRDFSisDefinedBy <em>RDF Sis Defined By</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFSResourceImpl#getRDFSseeAlso <em>RDF Ssee Also</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFSResourceImpl#getRDFtype <em>RD Ftype</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFSResourceImpl#getRDFSmember <em>RDF Smember</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFSResourceImpl#getNodeID <em>Node ID</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFSResourceImpl#getRDFScomment <em>RDF Scomment</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFSResourceImpl#getRDFSlabel <em>RDF Slabel</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFSResourceImpl#getUriRef <em>Uri Ref</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.RDFSResourceImpl#getSubjectStatement <em>Subject Statement</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class RDFSResourceImpl extends EObjectImpl implements RDFSResource {
	/**
	 * The cached value of the '{@link #getRDFSisDefinedBy() <em>RDF Sis Defined By</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRDFSisDefinedBy()
	 * @generated
	 * @ordered
	 */
	protected String uri;
	protected ArrayList customerPredicate;
	public String getURI()
	{
		if(this.uri!=null&&!uri.equals(""))
		{
			return this.uri;
		}
		else
		{
			return ((URIReference)this.getUriRef().get(0)).getURIString();
		}
	}
	public ArrayList getCustomTriples()
	{
		if(this.customerPredicate==null)
		{
			customerPredicate = new ArrayList();
		}
		return this.customerPredicate;
		
	}
	protected EList rdfSisDefinedBy = null;

	/**
	 * The cached value of the '{@link #getRDFSseeAlso() <em>RDF Ssee Also</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRDFSseeAlso()
	 * @generated
	 * @ordered
	 */
	protected EList rdfSseeAlso = null;

	/**
	 * The cached value of the '{@link #getRDFtype() <em>RD Ftype</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRDFtype()
	 * @generated
	 * @ordered
	 */
	protected EList rdFtype = null;

	/**
	 * The cached value of the '{@link #getRDFSmember() <em>RDF Smember</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRDFSmember()
	 * @generated
	 * @ordered
	 */
	protected EList rdfSmember = null;

	/**
	 * The default value of the '{@link #getNodeID() <em>Node ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNodeID()
	 * @generated
	 * @ordered
	 */
	protected static final String NODE_ID_EDEFAULT = "";

	/**
	 * The cached value of the '{@link #getNodeID() <em>Node ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNodeID()
	 * @generated
	 * @ordered
	 */
	protected String nodeID = NODE_ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getRDFScomment() <em>RDF Scomment</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRDFScomment()
	 * @generated
	 * @ordered
	 */
	protected EList rdfScomment = null;

	/**
	 * The cached value of the '{@link #getRDFSlabel() <em>RDF Slabel</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRDFSlabel()
	 * @generated
	 * @ordered
	 */
	protected EList rdfSlabel = null;

	/**
	 * The cached value of the '{@link #getUriRef() <em>Uri Ref</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUriRef()
	 * @generated
	 * @ordered
	 */
	protected EList uriRef = null;

	/**
	 * The cached value of the '{@link #getSubjectStatement() <em>Subject Statement</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSubjectStatement()
	 * @generated
	 * @ordered
	 */
	protected EList subjectStatement = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RDFSResourceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return RDFBasePackage.eINSTANCE.getRDFSResource();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getRDFSisDefinedBy() {
		if (rdfSisDefinedBy == null) {
			rdfSisDefinedBy = new EObjectResolvingEList(RDFSResource.class, this, RDFBasePackage.RDFS_RESOURCE__RDF_SIS_DEFINED_BY);
		}
		return rdfSisDefinedBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getRDFSseeAlso() {
		if (rdfSseeAlso == null) {
			rdfSseeAlso = new EObjectResolvingEList(RDFSResource.class, this, RDFBasePackage.RDFS_RESOURCE__RDF_SSEE_ALSO);
		}
		return rdfSseeAlso;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getRDFtype() {
		if (rdFtype == null) {
			try{
				rdFtype = new EObjectWithInverseResolvingEList.ManyInverse(RDFSClass.class, (InternalEObject)this.asType(RDFSResource.class), RDFBasePackage.RDFS_RESOURCE__RD_FTYPE, RDFSPackage.RDFS_CLASS__TYPED_RESOURCE);
			}catch(Exception e){e.printStackTrace();}
		}
		return rdFtype;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getRDFSmember() {
		if (rdfSmember == null) {
			rdfSmember = new EObjectResolvingEList(RDFSResource.class, this, RDFBasePackage.RDFS_RESOURCE__RDF_SMEMBER);
		}
		return rdfSmember;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getNodeID() {
		return nodeID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNodeID(String newNodeID) {
		String oldNodeID = nodeID;
		nodeID = newNodeID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RDFBasePackage.RDFS_RESOURCE__NODE_ID, oldNodeID, nodeID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getRDFScomment() {
		if (rdfScomment == null) {
			rdfScomment = new EObjectContainmentEList(PlainLiteral.class, this, RDFBasePackage.RDFS_RESOURCE__RDF_SCOMMENT);
		}
		return rdfScomment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getRDFSlabel() {
		if (rdfSlabel == null) {
			rdfSlabel = new EObjectContainmentEList(PlainLiteral.class, this, RDFBasePackage.RDFS_RESOURCE__RDF_SLABEL);
		}
		return rdfSlabel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getUriRef() {
		if (uriRef == null) {
			uriRef = new EObjectContainmentWithInverseEList(URIReference.class, this, RDFBasePackage.RDFS_RESOURCE__URI_REF, RDFBasePackage.URI_REFERENCE__RESOURCE);
		}
		return uriRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getSubjectStatement() {
		if (subjectStatement == null) {
			subjectStatement = new EObjectWithInverseResolvingEList(RDFStatement.class, this, RDFBasePackage.RDFS_RESOURCE__SUBJECT_STATEMENT, RDFBasePackage.RDF_STATEMENT__RD_FSUBJECT);
		}
		return subjectStatement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case RDFBasePackage.RDFS_RESOURCE__URI_REF:
					return ((InternalEList)getUriRef()).basicAdd(otherEnd, msgs);
				case RDFBasePackage.RDFS_RESOURCE__SUBJECT_STATEMENT:
					return ((InternalEList)getSubjectStatement()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case RDFBasePackage.RDFS_RESOURCE__RDF_SCOMMENT:
					return ((InternalEList)getRDFScomment()).basicRemove(otherEnd, msgs);
				case RDFBasePackage.RDFS_RESOURCE__RDF_SLABEL:
					return ((InternalEList)getRDFSlabel()).basicRemove(otherEnd, msgs);
				case RDFBasePackage.RDFS_RESOURCE__URI_REF:
					return ((InternalEList)getUriRef()).basicRemove(otherEnd, msgs);
				case RDFBasePackage.RDFS_RESOURCE__SUBJECT_STATEMENT:
					return ((InternalEList)getSubjectStatement()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.RDFS_RESOURCE__RDF_SIS_DEFINED_BY:
				return getRDFSisDefinedBy();
			case RDFBasePackage.RDFS_RESOURCE__RDF_SSEE_ALSO:
				return getRDFSseeAlso();
			case RDFBasePackage.RDFS_RESOURCE__RD_FTYPE:
				return getRDFtype();
			case RDFBasePackage.RDFS_RESOURCE__RDF_SMEMBER:
				return getRDFSmember();
			case RDFBasePackage.RDFS_RESOURCE__NODE_ID:
				return getNodeID();
			case RDFBasePackage.RDFS_RESOURCE__RDF_SCOMMENT:
				return getRDFScomment();
			case RDFBasePackage.RDFS_RESOURCE__RDF_SLABEL:
				return getRDFSlabel();
			case RDFBasePackage.RDFS_RESOURCE__URI_REF:
				return getUriRef();
			case RDFBasePackage.RDFS_RESOURCE__SUBJECT_STATEMENT:
				return getSubjectStatement();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.RDFS_RESOURCE__RDF_SIS_DEFINED_BY:
				getRDFSisDefinedBy().clear();
				getRDFSisDefinedBy().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDFS_RESOURCE__RDF_SSEE_ALSO:
				getRDFSseeAlso().clear();
				getRDFSseeAlso().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDFS_RESOURCE__RD_FTYPE:
				getRDFtype().clear();
				getRDFtype().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDFS_RESOURCE__RDF_SMEMBER:
				getRDFSmember().clear();
				getRDFSmember().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDFS_RESOURCE__NODE_ID:
				setNodeID((String)newValue);
				return;
			case RDFBasePackage.RDFS_RESOURCE__RDF_SCOMMENT:
				getRDFScomment().clear();
				getRDFScomment().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDFS_RESOURCE__RDF_SLABEL:
				getRDFSlabel().clear();
				getRDFSlabel().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDFS_RESOURCE__URI_REF:
				getUriRef().clear();
				getUriRef().addAll((Collection)newValue);
				return;
			case RDFBasePackage.RDFS_RESOURCE__SUBJECT_STATEMENT:
				getSubjectStatement().clear();
				getSubjectStatement().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.RDFS_RESOURCE__RDF_SIS_DEFINED_BY:
				getRDFSisDefinedBy().clear();
				return;
			case RDFBasePackage.RDFS_RESOURCE__RDF_SSEE_ALSO:
				getRDFSseeAlso().clear();
				return;
			case RDFBasePackage.RDFS_RESOURCE__RD_FTYPE:
				getRDFtype().clear();
				return;
			case RDFBasePackage.RDFS_RESOURCE__RDF_SMEMBER:
				getRDFSmember().clear();
				return;
			case RDFBasePackage.RDFS_RESOURCE__NODE_ID:
				setNodeID(NODE_ID_EDEFAULT);
				return;
			case RDFBasePackage.RDFS_RESOURCE__RDF_SCOMMENT:
				getRDFScomment().clear();
				return;
			case RDFBasePackage.RDFS_RESOURCE__RDF_SLABEL:
				getRDFSlabel().clear();
				return;
			case RDFBasePackage.RDFS_RESOURCE__URI_REF:
				getUriRef().clear();
				return;
			case RDFBasePackage.RDFS_RESOURCE__SUBJECT_STATEMENT:
				getSubjectStatement().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.RDFS_RESOURCE__RDF_SIS_DEFINED_BY:
				return rdfSisDefinedBy != null && !rdfSisDefinedBy.isEmpty();
			case RDFBasePackage.RDFS_RESOURCE__RDF_SSEE_ALSO:
				return rdfSseeAlso != null && !rdfSseeAlso.isEmpty();
			case RDFBasePackage.RDFS_RESOURCE__RD_FTYPE:
				return rdFtype != null && !rdFtype.isEmpty();
			case RDFBasePackage.RDFS_RESOURCE__RDF_SMEMBER:
				return rdfSmember != null && !rdfSmember.isEmpty();
			case RDFBasePackage.RDFS_RESOURCE__NODE_ID:
				return NODE_ID_EDEFAULT == null ? nodeID != null : !NODE_ID_EDEFAULT.equals(nodeID);
			case RDFBasePackage.RDFS_RESOURCE__RDF_SCOMMENT:
				return rdfScomment != null && !rdfScomment.isEmpty();
			case RDFBasePackage.RDFS_RESOURCE__RDF_SLABEL:
				return rdfSlabel != null && !rdfSlabel.isEmpty();
			case RDFBasePackage.RDFS_RESOURCE__URI_REF:
				return uriRef != null && !uriRef.isEmpty();
			case RDFBasePackage.RDFS_RESOURCE__SUBJECT_STATEMENT:
				return subjectStatement != null && !subjectStatement.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (nodeID: ");
		result.append(nodeID);
		result.append(')');
		return result.toString();
	}
	/**
     * Get a Java object of type <code>newType</code> that represents the same
     * resource as this object. 
     * 
     * <p>This method is added to support dynamic typing in RDF/OWL. It obtains 
     * another view of the same resource that this object represents. For example,
     * if, in a RDF graph, a resource is declared to be both a class and a property,
     * you can use the following code to access the resource as both a class
     * and a property:<p>
     * <pre>
     *     RDFFactory rdfFactory = ... // obtain a factory from implementation
     *     
     *     // get the class
     *     RDFSClass c = rdfFactory.createRDFSClass( "urn:example.com:poly" );
     *     
     *     // get the the same resource as a property
     *     RDFProperty p = (RDFProperty) c.asType( RDFProperty.class );
     *     
     *     // let's assume that the class c has no label yet
     *     assert( c.getRDFSLabel().size() == 0 );
     *     
     *     // if we add a label to the property
     *     p.getRDFSLabel().add( rdfFactory.createPlainLiteral("poly") );
     *     
     *     // since p and c represent the same resource, the label will also
     *     // appear in the class c
     *     assert( c.getRDFSLabel().size() == 1 );
     * </pre> 
     * <p>When you access the same resource using different types of Java objects, 
     * the implementation will automatically maintain the consisitency among the 
     * different Java objects.</p>
     * 
     * <a name="threeconditions"></a>
     * <p><strong>Three conditions must be met for this method to return successfully.</strong>
     * <ul>
     *   <li> This object itself can not be an instance of {@link org.eclipse.eodm.RDF.RDFWeb.Document Document},
     *   {@link org.eclipse.eodm.RDF.RDFS.RDFBase.RDFGraph RDFGraph} or 
     *   {@link org.eclipse.eodm.OWL.OWLBase.OWLGraph OWLGraph}. An alternative
     *   way to do this is shown at the bottom of this method documentation.<p>
     *   
     *   <li> The new type must be a subinterface of <code>RDFSResource</code>. 
     *   That is, the assertion <code>RDFSResource.class.isAssignableFrom( newType )</code> 
     *   must hold. This is obvious since RDFResource is the superinterface of
     *   all model resources in RDF/OWL models. In addition, the <code>newType</code>
     *   can not be any of the three: {@link org.eclipse.eodm.RDF.RDFWeb.Document Document},
     *   {@link org.eclipse.eodm.RDF.RDFS.RDFBase.RDFGraph RDFGraph} and 
     *   {@link org.eclipse.eodm.OWL.OWLBase.OWLGraph OWLGraph}. <p>
     *   
     *   <li> The statements in the context graph of this object support viewing
     *   this object as the <code>newType</code>. The semantics of "support" is
     *   delegated to the implementations of this method to clarify. For example,
     *   The new type is supported if there is a rdf:type statement in the graph for this
     *   resource and the new type. However, you can force the conversion of 
     *   a new type using the {@link RDFSResource#forceAsType(Class) forceAsType(newType)}
     *   method. You can also use the {@link #canAsType(Class)} method to check
     *   whether the new type is supported by the statements in the context graph.
     * </ul>
     * 
     * If you want to view the resources of {@link org.eclipse.eodm.RDF.RDFWeb.Document Document},
     *   {@link org.eclipse.eodm.RDF.RDFS.RDFBase.RDFGraph RDFGraph} or 
     *   {@link org.eclipse.eodm.OWL.OWLBase.OWLGraph OWLGraph} as other types, 
     *   you can do so as follows:<p>
     *   <pre>
     *      // suppose we have a named OWLGraph instance g with a URI Reference,
     *      // we first obtain the URI Reference 
     *      URIReference uriRef = g.getUriRef().get(0) ;
     *      
     *      // we can view it as an OWL individual in the graph itself as follows:
     *      OWLFactory owlFactory = .....   // get the OWL factory from implementation
     *      Individual i = owlFactory.createIndividual( g, uriRef );
     *      
     *      // Calling i's methods to add properties etc.
     *      ....
     *   </pre>
     *   
     * <p>After you obtained the new type object, you can safely cast the object to 
     * the new type as: 
     * <pre>NewType o2 = (NewType) o1.asType( NewType.class )</pre>
     *         
     * @param newType the Java class object representing the new type. 
     * @return a Java object of type <code>newType</code> and represents the same
     *         resource as this object. 
     * @throws UnsupportedViewTypeException if the <a href="#threeconditions">three 
     *         conditions documented above</a> are not met.
     *         
     * @see #canAsType(Class)
     * @see #forceAsType(Class)
     * 
     * @eodmext This method is added by EODM to support dynamic typing capability.         
     */
    public RDFSResource asType(Class newType) throws UnsupportedViewTypeException
    {
    	// this method is actually delegated to InternalCoreImpl    	
    	return null;
    }

    /**
     * Get a Java object of type <code>newType</code> that represents the same
     * resource as this object. 
     * 
     * <p>This method is almost identical to the 
     * {@link #asType(Class) asType(Class)} method except that it does not 
     * require the statements in the context graph of this object support viewing
     * this object as the <code>newType</code>. However, this method still
     * requires the top two conditions of the <a href="#threeconditions">three 
     * conditions documented above</a>.
     * 
     * @param newType the Java class object representing the new type
     * @return a Java object of type <code>newType</code> and represents the same
     *         resource as this object. 
     * @throws UnsupportedViewTypeException if the top two conditions of the
     *         <a href="#threeconditions">three conditions documented above</a> 
     *         are not met.
     *         
     * @see #asType(Class)
     * @see #canAsType(Class)
     * 
     * @eodmext This method is added by EODM to support dynamic typing capability.
     */
    public RDFSResource forceAsType(Class newType) throws UnsupportedViewTypeException
    {
    	// this method is actually delegated to InternalCoreImpl    	
    	return null;
    }

    /**
     * Explicitly check whether we can obtain a new type view of this object.
     *  
     * Explicitly check whether the <a href="#threeconditions">three conditions 
     * documented above</a> are met for obtaining a new type view of this object
     * for the same resource this object represents. Especially, check whether 
     * the statements in the context graph of this object support viewing 
     * this object as the <code>newType</code>. Implementation of this method
     * should clarify the semantics of "support" clearly.
     * 
     * @param newType the Java class object representing the new type
     * @return whether the new type is supported.
     * 
     * @see #asType(Class)
     * @see #forceAsType(Class)
     * 
     * @eodmext This method is added by EODM to support dynamic typing capability.
     */
    public boolean canAsType(Class newType)
    {
    	// this method is actually delegated to InternalCoreImpl
    	return true;
    }

    public RDFSResource[] getAllTypeViews()
    {
    	return null ;  // for overiding
    }

} //RDFSResourceImpl
