/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.xtend.shared.ui.wizards.EclipseHelper;
import org.eclipse.xtend.shared.ui.wizards.NewOAWResourcePage;

public abstract class NewExtXptResourceWizard
extends BasicNewResourceWizard {
    private NewOAWResourcePage mainPage;
    private String extension;
    private String title;
    private String description;
    private String initial;
    private String initialContents;

    public NewExtXptResourceWizard(String initial, String extension, String title, String description, String initialContents) {
        this.initial = initial;
        this.extension = extension;
        this.title = title;
        this.description = description;
        this.initialContents = initialContents;
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new NewOAWResourcePage("newFilePage1", this.getSelection(), this.initial, this.extension, this.initialContents);
        this.mainPage.setTitle(this.title);
        this.mainPage.setDescription(this.description);
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle("New File");
        this.setNeedsProgressMonitor(true);
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/wizban/newfile_wiz.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    public boolean canFinish() {
        return this.mainPage.getFileName().endsWith("." + this.extension);
    }

    public boolean performFinish() {
        IFile file = this.mainPage.createNewFile();
        if (file == null) {
            return false;
        }
        this.selectAndReveal((IResource)file);
        EclipseHelper.openFileToEdit(this.getShell(), file);
        return true;
    }
}

