/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jet.internal.runtime.model.EntityResolverFactory;
import org.eclipse.jet.runtime.model.IModelLoader;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLDOMLoader
implements IModelLoader {
    public boolean canLoad(String kind) {
        return true;
    }

    public Object load(URL modelUrl) throws IOException {
        InputStream inputStream = modelUrl.openStream();
        InputSource inputSource = new InputSource(inputStream);
        Document document = this.parse(inputSource, modelUrl.toExternalForm());
        return document;
    }

    public Object load(URL modelUrl, String kind) throws IOException {
        return this.load(modelUrl);
    }

    public Object loadFromString(String serializedModel, String kind) throws IOException {
        InputSource inputSource = new InputSource(new StringReader(serializedModel));
        return this.parse(inputSource, null);
    }

    private Document parse(InputSource inputSource, String baseLocation) throws IOException {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            EntityResolver entityResolver = EntityResolverFactory.getEntityResolver(baseLocation);
            if (entityResolver != null) {
                builder.setEntityResolver(entityResolver);
            }
            Document document = builder.parse(inputSource);
            return document;
        }
        catch (ParserConfigurationException e) {
            IOException ioex = new IOException();
            ioex.initCause(e);
            throw ioex;
        }
        catch (SAXException e) {
            IOException ioex = new IOException();
            ioex.initCause(e);
            throw ioex;
        }
    }
}

