/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.java;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jet.BodyContentWriter;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.taglib.java.JavaFileAction;
import org.eclipse.jet.internal.taglib.java.PackageTag;
import org.eclipse.jet.taglib.AbstractEmptyTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.taglib.java.JavaActionsUtil;
import org.eclipse.jet.taglib.workspace.WorkspaceContextExtender;
import org.eclipse.jet.transform.TransformContextExtender;

public abstract class AbstractJavaFileTag
extends AbstractEmptyTag {
    public final void doAction(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        IPath srcFolderPath;
        String fileName = this.getFileName();
        String pkgName = this.getAttribute("package");
        String srcFolder = this.getAttribute("srcFolder");
        String template = this.getAttribute("template");
        String encoding = this.getAttribute("encoding");
        boolean derived = Boolean.valueOf(this.getAttribute("derived"));
        boolean replace = true;
        if (td.hasAttribute("replace")) {
            replace = Boolean.valueOf(this.getAttribute("replace"));
        }
        WorkspaceContextExtender wce = WorkspaceContextExtender.getInstance(context);
        if (srcFolder == null && pkgName == null) {
            PackageTag pkgTag = JavaActionsUtil.findContainingJavaPackageTag(this);
            pkgName = pkgTag.getPackageName();
            srcFolderPath = pkgTag.getSourceFolderPath();
        } else if (srcFolder == null) {
            srcFolderPath = wce.getContainer().getFullPath().makeRelative();
        } else {
            srcFolderPath = new Path(srcFolder).makeRelative();
            if (srcFolderPath.segmentCount() == 0) {
                String attribute = "sourceFolder";
                String msg = JET2Messages.AbstractJavaFileTag_EmptyAttributeNotAllowed;
                throw new JET2TagException(MessageFormat.format(msg, attribute));
            }
        }
        BodyContentWriter content = new BodyContentWriter();
        TransformContextExtender tce = TransformContextExtender.getInstance(context);
        tce.execute(template, content);
        if (srcFolderPath == null || pkgName == null) {
            throw new JET2TagException(JET2Messages.AbstractJavaFileTag_CouldNotWrite_UnknownSourceFolder);
        }
        wce.addAction(new JavaFileAction(srcFolderPath, pkgName, fileName, content, replace, encoding, derived, td, tce.getTemplatePath()));
    }

    protected abstract String getFileName() throws JET2TagException;
}

