/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.prov.server.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.net4j.examples.prov.server.DateFormatter;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.spring.impl.ServiceImpl;

public class SimpleDateFormatter
extends ServiceImpl
implements DateFormatter {
    protected String pattern;
    protected String timeZone;
    protected Locale locale;
    private transient SimpleDateFormat simpleDateFormat;

    public String format(Date date) {
        return this.simpleDateFormat.format(date);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.doSet("pattern", pattern);
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.doSet("timeZone", timeZone);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.doSet("locale", locale);
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("pattern");
        this.simpleDateFormat = new SimpleDateFormat(this.pattern, this.locale);
        if (this.timeZone != null) {
            this.simpleDateFormat.setTimeZone(TimeZone.getTimeZone(this.timeZone));
        }
    }

    protected void deactivate() throws Exception {
        this.locale = null;
        this.pattern = null;
        this.timeZone = null;
        this.simpleDateFormat = null;
        super.deactivate();
    }
}

