/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.samples.issues.enumtest;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class ItemType
extends AbstractEnumerator
implements Serializable {
    public static final int PRODUCT = 0;
    public static final int PRODUCT_FAMILY = 1;
    public static final ItemType PRODUCT_LITERAL = new ItemType(0, "Product", "Product");
    public static final ItemType PRODUCT_FAMILY_LITERAL = new ItemType(1, "ProductFamily", "ProductFamily");
    private static final ItemType[] VALUES_ARRAY = new ItemType[]{PRODUCT_LITERAL, PRODUCT_FAMILY_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static ItemType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ItemType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ItemType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ItemType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ItemType get(int value) {
        switch (value) {
            case 0: {
                return PRODUCT_LITERAL;
            }
            case 1: {
                return PRODUCT_FAMILY_LITERAL;
            }
        }
        return null;
    }

    private ItemType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

