/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.protocol.CDOAuthenticationResult;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.internal.server.Session;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.AuthenticationRequest;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.ISessionManager;
import org.eclipse.emf.cdo.server.SessionCreationException;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.IRandomizer;
import org.eclipse.net4j.util.security.IUserManager;
import org.eclipse.net4j.util.security.NegotiationException;
import org.eclipse.net4j.util.security.Randomizer;
import org.eclipse.net4j.util.security.SecurityUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManager
extends Container<ISession>
implements ISessionManager {
    public static final int DEFAULT_TOKEN_LENGTH = 1024;
    public static final long DEFAULT_NEGOTIATION_TIMEOUT = 15000L;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SESSION, SessionManager.class);
    private IRepository repository;
    private String encryptionAlgorithmName = "PBEWithMD5AndDES";
    private byte[] encryptionSaltBytes = SecurityUtil.DEFAULT_SALT;
    private int encryptionIterationCount = 20;
    private int tokenLength = 1024;
    private IRandomizer randomizer;
    private IUserManager userManager;
    private long negotiationTimeout = 15000L;
    private Map<Integer, Session> sessions = new HashMap<Integer, Session>();
    private int lastSessionID;

    @Override
    public IRepository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(IRepository repository) {
        this.checkInactive();
        this.repository = repository;
    }

    public String getEncryptionAlgorithmName() {
        return this.encryptionAlgorithmName;
    }

    public void setEncryptionAlgorithmName(String encryptionAlgorithmName) {
        this.checkInactive();
        this.encryptionAlgorithmName = encryptionAlgorithmName;
    }

    public byte[] getEncryptionSaltBytes() {
        return this.encryptionSaltBytes;
    }

    public void setEncryptionSaltBytes(byte[] encryptionSaltBytes) {
        this.checkInactive();
        this.encryptionSaltBytes = encryptionSaltBytes;
    }

    public int getEncryptionIterationCount() {
        return this.encryptionIterationCount;
    }

    public void setEncryptionIterationCount(int encryptionIterationCount) {
        this.checkInactive();
        this.encryptionIterationCount = encryptionIterationCount;
    }

    public int getTokenLength() {
        return this.tokenLength;
    }

    public void setTokenLength(int tokenLength) {
        this.checkInactive();
        this.tokenLength = tokenLength;
    }

    public IRandomizer getRandomizer() {
        return this.randomizer;
    }

    public void setRandomizer(IRandomizer randomizer) {
        this.checkInactive();
        this.randomizer = randomizer;
    }

    public IUserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(IUserManager userManager) {
        this.userManager = userManager;
    }

    public long getNegotiationTimeout() {
        return this.negotiationTimeout;
    }

    public void setNegotiationTimeout(long negotiationTimeout) {
        this.negotiationTimeout = negotiationTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session[] getSessions() {
        Map<Integer, Session> map = this.sessions;
        synchronized (map) {
            return this.sessions.values().toArray(new Session[this.sessions.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getSession(int sessionID) {
        this.checkActive();
        Map<Integer, Session> map = this.sessions;
        synchronized (map) {
            return this.sessions.get(sessionID);
        }
    }

    public ISession[] getElements() {
        return this.getSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<Integer, Session> map = this.sessions;
        synchronized (map) {
            return this.sessions.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session openSession(CDOServerProtocol protocol) throws SessionCreationException {
        int id = ++this.lastSessionID;
        if (TRACER.isEnabled()) {
            TRACER.trace("Opening session " + id);
        }
        String userID = this.authenticateUser(protocol);
        Session session = new Session(this, protocol, id, userID);
        Map<Integer, Session> map = this.sessions;
        synchronized (map) {
            this.sessions.put(id, session);
        }
        this.fireElementAddedEvent(session);
        this.handleRemoteSessionNotification((byte)1, session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(Session session) {
        int sessionID = session.getSessionID();
        ISession removeSession = null;
        Map<Integer, Session> map = this.sessions;
        synchronized (map) {
            removeSession = this.sessions.remove(sessionID);
        }
        if (removeSession != null) {
            this.fireElementRemovedEvent(session);
            this.handleRemoteSessionNotification((byte)2, session);
        }
    }

    public void handleCommitNotification(long timeStamp, CDOPackageUnit[] packageUnits, List<CDOIDAndVersion> dirtyIDs, List<CDOID> detachedObjects, List<CDORevisionDelta> deltas, Session excludedSession) {
        Session[] sessionArray = this.getSessions();
        int n = sessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Session session = sessionArray[n2];
            if (session != excludedSession) {
                session.handleCommitNotification(timeStamp, packageUnits, dirtyIDs, detachedObjects, deltas);
            }
            ++n2;
        }
    }

    public void handleRemoteSessionNotification(byte opcode, Session excludedSession) {
        Session[] sessionArray = this.getSessions();
        int n = sessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Session session = sessionArray[n2];
            if (session != excludedSession && session.isSubscribed()) {
                session.handleRemoteSessionNotification(opcode, excludedSession);
            }
            ++n2;
        }
    }

    protected String authenticateUser(CDOServerProtocol protocol) throws SecurityException {
        if (this.userManager == null) {
            return null;
        }
        try {
            byte[] randomToken = this.createRandomToken();
            CDOAuthenticationResult result = (CDOAuthenticationResult)new AuthenticationRequest(protocol, randomToken).send(this.negotiationTimeout);
            String userID = result.getUserID();
            byte[] cryptedToken = this.encryptToken(userID, randomToken);
            boolean success = Arrays.equals(result.getCryptedToken(), cryptedToken);
            if (success) {
                return userID;
            }
            throw new SecurityException("User not authenticated");
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    protected byte[] createRandomToken() {
        byte[] token = new byte[this.tokenLength];
        this.randomizer.nextBytes(token);
        return token;
    }

    protected byte[] encryptToken(String userID, byte[] token) throws NegotiationException {
        try {
            return this.userManager.encrypt(userID, token, this.getEncryptionAlgorithmName(), this.getEncryptionSaltBytes(), this.getEncryptionIterationCount());
        }
        catch (Exception ex) {
            OM.LOG.error("Token encryption failed", (Throwable)ex);
            return null;
        }
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (this.userManager == null) {
            OM.LOG.info("No user manager configured. Users will not be authenticated");
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (this.userManager != null) {
            if (this.randomizer == null) {
                this.randomizer = new Randomizer();
            }
            LifecycleUtil.activate((Object)this.randomizer);
        }
    }

    protected void doDeactivate() throws Exception {
        Session[] activeSessions = this.getSessions();
        int i = 0;
        while (i < activeSessions.length) {
            LifecycleUtil.deactivate((Object)activeSessions[i]);
            ++i;
        }
        super.doDeactivate();
    }
}

