/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.cda.core.profile.ActRelationship;
import org.eclipse.mdht.uml.cda.core.profile.CDATemplate;
import org.eclipse.mdht.uml.cda.core.profile.ConformsTo;
import org.eclipse.mdht.uml.cda.core.profile.Entry;
import org.eclipse.mdht.uml.cda.core.profile.EntryRelationship;
import org.eclipse.mdht.uml.cda.core.profile.Inline;
import org.eclipse.mdht.uml.cda.core.profile.LogicalConstraint;
import org.eclipse.mdht.uml.cda.core.profile.Participation;
import org.eclipse.mdht.uml.cda.core.profile.TextValue;
import org.eclipse.mdht.uml.cda.core.profile.Validation;
import org.eclipse.mdht.uml.cda.core.profile.VocabSpecification;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class CDAProfileUtil {
    public static ActRelationship getActRelationship(Association association) {
        ActRelationship actRelationship = null;
        Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)association, "ActRelationship");
        if (stereotype != null) {
            actRelationship = (ActRelationship)association.getStereotypeApplication(stereotype);
        }
        return actRelationship;
    }

    public static LogicalConstraint getLogicalConstraint(Constraint constraint) {
        LogicalConstraint logicalClassifier = null;
        Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)constraint, "LogicalConstraint");
        if (stereotype != null) {
            logicalClassifier = (LogicalConstraint)constraint.getStereotypeApplication(stereotype);
        }
        return logicalClassifier;
    }

    public static Participation getParticipation(Association association) {
        Participation participation = null;
        Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)association, "Participation");
        if (stereotype != null) {
            participation = (Participation)association.getStereotypeApplication(stereotype);
        }
        return participation;
    }

    public static TextValue getTextValue(Property property) {
        TextValue textValue = null;
        Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)property, "TextValue");
        if (stereotype != null) {
            textValue = (TextValue)property.getStereotypeApplication(stereotype);
        }
        return textValue;
    }

    public static ConformsTo getConformsTo(Generalization generalization) {
        ConformsTo conformsTo = null;
        Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)generalization, "ConformsTo");
        if (stereotype != null) {
            conformsTo = (ConformsTo)generalization.getStereotypeApplication(stereotype);
        }
        return conformsTo;
    }

    public static Inline getInline(Class theClass) {
        Inline inline = null;
        Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)theClass, "Inline");
        if (stereotype != null) {
            inline = (Inline)theClass.getStereotypeApplication(stereotype);
        }
        return inline;
    }

    public static EntryRelationship getEntryRelationship(Association association) {
        EntryRelationship entryRelationship = null;
        Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)association, "EntryRelationship");
        if (stereotype != null) {
            entryRelationship = (EntryRelationship)association.getStereotypeApplication(stereotype);
        }
        return entryRelationship;
    }

    public static Entry getEntry(Association association) {
        Entry entry = null;
        Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)association, "Entry");
        if (stereotype != null) {
            entry = (Entry)association.getStereotypeApplication(stereotype);
        }
        return entry;
    }

    public static CDATemplate getCDATemplate(Class clazz) {
        CDATemplate cdaTemplate = null;
        Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)clazz, "CDATemplate");
        if (stereotype != null) {
            cdaTemplate = (CDATemplate)clazz.getStereotypeApplication(stereotype);
        }
        return cdaTemplate;
    }

    public static Validation getValidation(Element element) {
        Validation validation = null;
        Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype(element, "Validation");
        if (stereotype != null) {
            validation = (Validation)element.getStereotypeApplication(stereotype);
        }
        return validation;
    }

    public static boolean isMandatory(Element element) {
        boolean result = false;
        Iterator iter = element.getStereotypeApplications().iterator();
        while (!result && iter.hasNext()) {
            Object next = iter.next();
            boolean bl = result = next instanceof Validation && ((Validation)next).isMandatory();
        }
        return result;
    }

    public static VocabSpecification getVocabSpecification(Property property) {
        VocabSpecification vocabSpecification = null;
        Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)property, "VocabSpecification");
        if (stereotype != null) {
            vocabSpecification = (VocabSpecification)property.getStereotypeApplication(stereotype);
        }
        return vocabSpecification;
    }

    public static Profile getCDAProfile(ResourceSet resourceSet) {
        Profile profile = null;
        Resource profileResource = resourceSet.getResource(URI.createURI((String)"pathmap://CDA_PROFILES/CDA.profile.uml"), true);
        if (profileResource != null) {
            profile = (Profile)EcoreUtil.getObjectByType((Collection)profileResource.getContents(), (EClassifier)UMLPackage.eINSTANCE.getProfile());
        }
        return profile;
    }

    public static Stereotype getAppliedCDAStereotype(Element element, String stereotypeName) {
        EList stereotypes;
        Stereotype stereotype = null;
        if (element == null || element.eResource() == null) {
            return null;
        }
        Profile profile = CDAProfileUtil.getCDAProfile(element.eResource().getResourceSet());
        if (profile != null && (stereotype = profile.getOwnedStereotype(stereotypeName)) != null && !element.isStereotypeApplied(stereotype) && !(stereotypes = element.getAppliedSubstereotypes(stereotype)).isEmpty()) {
            stereotype = (Stereotype)stereotypes.get(0);
        }
        return element.isStereotypeApplied(stereotype) ? stereotype : null;
    }

    public static List<Stereotype> getAppliedStereotypes(Element element, String stereotypeName) {
        Stereotype stereotype;
        ArrayList<Stereotype> appliedStereotypes = new ArrayList<Stereotype>();
        if (element == null || element.eResource() == null) {
            return null;
        }
        Profile profile = CDAProfileUtil.getCDAProfile(element.eResource().getResourceSet());
        if (profile != null && (stereotype = profile.getOwnedStereotype(stereotypeName)) != null && !element.isStereotypeApplied(stereotype)) {
            EList stereotypes = element.getAppliedSubstereotypes(stereotype);
            appliedStereotypes.addAll((Collection<Stereotype>)stereotypes);
        }
        return appliedStereotypes;
    }

    public static Stereotype applyCDAStereotype(Element element, String stereotypeName) {
        Stereotype stereotype = null;
        Profile profile = CDAProfileUtil.getCDAProfile(element.eResource().getResourceSet());
        if (profile != null && (stereotype = profile.getOwnedStereotype(stereotypeName)) != null && !element.isStereotypeApplied(stereotype)) {
            org.eclipse.uml2.uml.util.UMLUtil.safeApplyStereotype((Element)element, (Stereotype)stereotype);
        }
        return stereotype;
    }

    public static void unapplyCDAStereotype(Element element, String stereotypeName) {
        String qname = "CDA::" + stereotypeName;
        Stereotype stereotype = element.getApplicableStereotype(qname);
        if (stereotype != null && element.isStereotypeApplied(stereotype)) {
            element.unapplyStereotype(stereotype);
        }
    }

    public static Profile getAppliedCDAProfile(Element element) {
        return UMLUtil.getAppliedProfile((String)"pathmap://CDA_PROFILES/CDA.profile.uml", (Element)element);
    }

    public static boolean isValidationStereotype(Stereotype stereotype) {
        String qname = "CDA::Validation";
        boolean result = "CDA::Validation".equals(stereotype.getQualifiedName());
        if (!result) {
            for (Classifier next : stereotype.allParents()) {
                if (!"CDA::Validation".equals(next.getQualifiedName())) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

