/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.transform.core;

import org.eclipse.mdht.transform.core.IPhase;
import org.eclipse.mdht.transform.core.IRule;
import org.eclipse.mdht.transform.core.PhaseKind;
import org.eclipse.mdht.transform.core.RuleBuilder;
import org.eclipse.mdht.transform.core.RuleKind;
import org.eclipse.mdht.transform.core.TransformationBuilder;
import org.eclipse.mdht.transform.core.impl.Phase;
import org.eclipse.mdht.transform.core.impl.Transformation;

public class PhaseBuilder {
    private final TransformationBuilder parent;
    private Phase product;

    PhaseBuilder(TransformationBuilder parent, Transformation transformation, String id, String label) {
        this(parent, new Phase(transformation, id, PhaseKind.TRANSFORM, label));
        transformation.addPhase(this.product);
    }

    PhaseBuilder(TransformationBuilder parent, IPhase phase) {
        this.parent = parent;
        this.product = (Phase)phase;
    }

    public RuleBuilder rule(IRule rule) {
        return new RuleBuilder(this, this.product, rule);
    }

    public RuleBuilder rule(String id, RuleKind kind, String label) {
        return new RuleBuilder(this, this.product, id, kind, label);
    }

    public RuleBuilder getRule(String id) {
        return new RuleBuilder(this, this.product.getRule(id));
    }

    public PhaseBuilder phase(String id, String label) {
        return this.parent.phase(id, label);
    }

    public TransformationBuilder done() {
        return this.parent;
    }
}

