/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.mdht.uml.cda.core.util.CDACommonUtils;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.cda.core.util.ClinicalDocumentCreator;
import org.eclipse.mdht.uml.cda.ui.filters.TextAttributeFilter;
import org.eclipse.mdht.uml.cda.ui.properties.MemoDialog;
import org.eclipse.mdht.uml.ui.properties.internal.sections.InstanceSampleSection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;

public class CDAInstanceSampleSection
extends InstanceSampleSection {
    protected Property getBaseProperty(Property property) {
        return CDACommonUtils.getCDAProperty((Property)property);
    }

    protected boolean isOptionalOrRequiredButNotFixed(Property property) {
        if (super.isOptionalOrRequiredButNotFixed(property)) {
            return true;
        }
        return new TextAttributeFilter().select(property) && CDAProfileUtil.getTextValue((Property)property) == null;
    }

    protected Collection<Property> getAllAttributes(Class cls) {
        return CDACommonUtils.allAttributes((Class)cls);
    }

    protected void createOtherFormUI() {
        final Button buttonSample = this.getWidgetFactory().createButton(this.body, "Show Sample Instance", 0);
        buttonSample.setLayoutData((Object)new TableWrapData(2, 16, 1, 2));
        Button buttonSampleMin = this.getWidgetFactory().createButton(this.body, "Show Minimal Instance", 0);
        buttonSampleMin.setLayoutData((Object)new TableWrapData(2, 16, 1, 2));
        final Button buttonSampleMax = this.getWidgetFactory().createButton(this.body, "Show Maximal Instance", 0);
        buttonSampleMax.setLayoutData((Object)new TableWrapData(2, 16, 1, 2));
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Class umlClinicalDocument = CDACommonUtils.getClinicalDocument((Element)CDAInstanceSampleSection.this.umlElement);
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                CDACommonUtils.patchResourceSet((ResourceSet)resourceSet);
                ArrayList statuses = new ArrayList();
                ClinicalDocumentCreator creator = new ClinicalDocumentCreator(umlClinicalDocument, (ResourceSet)resourceSet, statuses);
                creator.enableSampleData(true);
                creator.enableSampleDataExpansion(e.getSource() == buttonSample);
                Collection<Object> props = Collections.emptyList();
                if (e.getSource() == buttonSampleMax) {
                    props = CDACommonUtils.getAllContents((Resource)CDAInstanceSampleSection.this.umlElement.eResource(), Property.class);
                }
                EObject newObject = creator.initializeSnippet((Class)CDAInstanceSampleSection.this.umlElement, props);
                String xml = creator.toXMLString(newObject, (Class)CDAInstanceSampleSection.this.umlElement);
                if (!statuses.isEmpty()) {
                    MultiStatus status = new MultiStatus("au.net.electronichealth.ci.common", 4, statuses.toArray(new IStatus[0]), "Errors occured during sample XML generation", null);
                    StatusManager.getManager().handle((IStatus)status);
                }
                MemoDialog dialog = new MemoDialog(Display.getCurrent().getActiveShell(), !statuses.isEmpty() ? "Sample XML (see Error Log for more information)" : "Sample XML", xml);
                dialog.open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        buttonSample.addSelectionListener(listener);
        buttonSampleMin.addSelectionListener(listener);
        buttonSampleMax.addSelectionListener(listener);
    }
}

