/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunResourceVolumesVariablesModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RunImageResourcesTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "RunResourcesTab.name";
    private static final int COLUMNS = 2;
    private final DataBindingContext dbc = new DataBindingContext();
    private ImageRunResourceVolumesVariablesModel model = null;
    private Composite container;

    public RunImageResourcesTab(ImageRunResourceVolumesVariablesModel model) {
        this.model = model;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(1, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo(container);
        if (this.model == null) {
            this.setErrorMessage(LaunchMessages.getString("NoConnectionError.msg"));
        } else {
            this.setErrorMessage(null);
            this.createResourceSettingsContainer(container);
        }
        this.setControl((Control)container);
    }

    private void createResourceSettingsContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().spacing(10, 2).applyTo(container);
        Button enableResourceLimitationButton = new Button(container, 32);
        enableResourceLimitationButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.enableLimitationButton"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)enableResourceLimitationButton);
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)enableResourceLimitationButton), BeanProperties.value(ImageRunResourceVolumesVariablesModel.class, (String)"enableResourceLimitations").observe((Object)this.model));
        int COLUMNS = 5;
        int INDENT = 20;
        Composite subContainer = new Composite(container, 0);
        this.setContainer(subContainer);
        GridDataFactory.fillDefaults().align(4, 4).indent(20, 0).span(5, 1).grab(true, false).applyTo((Control)subContainer);
        GridLayoutFactory.fillDefaults().numColumns(5).margins(6, 6).spacing(10, 2).applyTo(subContainer);
        Label cpuPriorityLabel = new Label(subContainer, 0);
        cpuPriorityLabel.setText(WizardMessages.getString("ImageRunResourceVolVarPage.cpuPriorityLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)cpuPriorityLabel);
        Button lowCPULimitationButton = new Button(subContainer, 16);
        lowCPULimitationButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.lowButton"));
        this.bindButton(lowCPULimitationButton, 512L);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)lowCPULimitationButton);
        Button mediumCPULimitationButton = new Button(subContainer, 16);
        mediumCPULimitationButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.mediumButton"));
        this.bindButton(mediumCPULimitationButton, 1024L);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)mediumCPULimitationButton);
        Button highCPULimitationButton = new Button(subContainer, 16);
        highCPULimitationButton.setText(WizardMessages.getString("ImageRunResourceVolVarPage.highButton"));
        this.bindButton(highCPULimitationButton, 2048L);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)highCPULimitationButton);
        Label memoryLimitLabel = new Label(subContainer, 0);
        memoryLimitLabel.setText(WizardMessages.getString("ImageRunResourceVolVarPage.memoryLimit"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)memoryLimitLabel);
        Scale memoryLimitSpinner = new Scale(subContainer, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(2, 1).applyTo((Control)memoryLimitSpinner);
        memoryLimitSpinner.setBackground(Display.getDefault().getSystemColor(37));
        memoryLimitSpinner.setMinimum(0);
        memoryLimitSpinner.setMaximum(this.model.getTotalMemory());
        memoryLimitSpinner.setPageIncrement(64);
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)memoryLimitSpinner), BeanProperties.value(ImageRunResourceVolumesVariablesModel.class, (String)"memoryLimit").observe((Object)this.model));
        Text memoryLimitValueText = new Text(subContainer, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).hint(50, -1).applyTo((Control)memoryLimitValueText);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)memoryLimitValueText), BeanProperties.value(ImageRunResourceVolumesVariablesModel.class, (String)"memoryLimit").observe((Object)this.model));
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)memoryLimitSpinner), BeanProperties.value(ImageRunResourceVolumesVariablesModel.class, (String)"memoryLimit").observe((Object)this.model));
        Label memoryLimitValueLabel = new Label(subContainer, 0);
        memoryLimitValueLabel.setText("MB");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)memoryLimitValueLabel);
        IObservableValue enableResourceLimitationsObservable = BeanProperties.value(ImageRunResourceVolumesVariablesModel.class, (String)"enableResourceLimitations").observe((Object)this.model);
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)enableResourceLimitationButton), enableResourceLimitationsObservable);
        enableResourceLimitationsObservable.addChangeListener(this.onEnableResourceLimitation(subContainer));
        this.toggleResourceLimitationControls(subContainer);
    }

    private void setContainer(Composite container) {
        this.container = container;
    }

    private Composite getContainer() {
        return this.container;
    }

    private Binding bindButton(Button button, final long cpuShares) {
        return this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)button), BeanProperties.value(ImageRunResourceVolumesVariablesModel.class, (String)"cpuShareWeight").observe((Object)this.model), new UpdateValueStrategy(this){

            public Object convert(Object value) {
                if (value.equals(Boolean.TRUE)) {
                    return cpuShares;
                }
                return 0L;
            }
        }, new UpdateValueStrategy(this){

            public Object convert(Object value) {
                return value.equals(cpuShares);
            }
        });
    }

    private IChangeListener onEnableResourceLimitation(Composite container) {
        return event -> this.toggleResourceLimitationControls(container);
    }

    private void toggleResourceLimitationControls(Composite container) {
        for (Control childControl : container.getChildren()) {
            if (this.model.isEnableResourceLimitations()) {
                childControl.setEnabled(true);
            } else {
                childControl.setEnabled(false);
            }
            this.updateLaunchConfigurationDialog();
        }
    }

    public Image getImage() {
        return SWTImagesFactory.get("org.eclipse.linuxtools.docker.ui.resource_obj.gif");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (this.model == null) {
            return;
        }
        try {
            boolean enableLimits = configuration.getAttribute("enableLimits", false);
            this.model.setEnableResourceLimitations(enableLimits);
            long cpuShareWeight = Long.parseLong(configuration.getAttribute("cpuPriority", Long.toString(1024L)));
            this.model.setCpuShareWeight(cpuShareWeight);
            int maxMemory = this.model.getTotalMemory();
            long memoryLimit = Long.parseLong(configuration.getAttribute("memoryLimit", Long.toString(512L)));
            this.model.setMemoryLimit(Math.min((long)maxMemory, memoryLimit));
            this.toggleResourceLimitationControls(this.getContainer());
        }
        catch (CoreException e) {
            Activator.logErrorMessage(LaunchMessages.getString("RunDockerImageLaunchConfiguration.load.failure"), e);
        }
        this.model.addPropertyChangeListener(new LaunchConfigurationChangeListener());
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.model == null) {
            return;
        }
        configuration.setAttribute("enableLimits", this.model.isEnableResourceLimitations());
        configuration.setAttribute("memoryLimit", Long.toString(this.model.getMemoryLimit()));
        configuration.setAttribute("cpuPriority", Long.toString(this.model.getCpuShareWeight()));
    }

    public String getName() {
        return LaunchMessages.getString(TAB_NAME);
    }

    private class LaunchConfigurationChangeListener
    implements PropertyChangeListener {
        private LaunchConfigurationChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RunImageResourcesTab.this.updateLaunchConfigurationDialog();
        }
    }
}

