/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.client.messages.ImageSearchResult;

final class ImmutableImageSearchResult
implements ImageSearchResult {
    private final String description;
    private final boolean official;
    private final boolean automated;
    private final String name;
    private final int starCount;

    private ImmutableImageSearchResult(String description, boolean official, boolean automated, String name, int starCount) {
        this.description = description;
        this.official = official;
        this.automated = automated;
        this.name = name;
        this.starCount = starCount;
    }

    @Override
    @JsonProperty(value="description")
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="is_official")
    public boolean official() {
        return this.official;
    }

    @Override
    @JsonProperty(value="is_automated")
    public boolean automated() {
        return this.automated;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="star_count")
    public int starCount() {
        return this.starCount;
    }

    public final ImmutableImageSearchResult withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableImageSearchResult(newValue, this.official, this.automated, this.name, this.starCount);
    }

    public final ImmutableImageSearchResult withOfficial(boolean value) {
        if (this.official == value) {
            return this;
        }
        return new ImmutableImageSearchResult(this.description, value, this.automated, this.name, this.starCount);
    }

    public final ImmutableImageSearchResult withAutomated(boolean value) {
        if (this.automated == value) {
            return this;
        }
        return new ImmutableImageSearchResult(this.description, this.official, value, this.name, this.starCount);
    }

    public final ImmutableImageSearchResult withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableImageSearchResult(this.description, this.official, this.automated, newValue, this.starCount);
    }

    public final ImmutableImageSearchResult withStarCount(int value) {
        if (this.starCount == value) {
            return this;
        }
        return new ImmutableImageSearchResult(this.description, this.official, this.automated, this.name, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableImageSearchResult && this.equalTo(0, (ImmutableImageSearchResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableImageSearchResult another) {
        return this.description.equals(another.description) && this.official == another.official && this.automated == another.automated && this.name.equals(another.name) && this.starCount == another.starCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + Boolean.hashCode(this.official);
        h += (h << 5) + Boolean.hashCode(this.automated);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.starCount;
        return h;
    }

    public String toString() {
        return "ImageSearchResult{description=" + this.description + ", official=" + this.official + ", automated=" + this.automated + ", name=" + this.name + ", starCount=" + this.starCount + "}";
    }

    public static ImmutableImageSearchResult copyOf(ImageSearchResult instance) {
        if (instance instanceof ImmutableImageSearchResult) {
            return (ImmutableImageSearchResult)instance;
        }
        return ImmutableImageSearchResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_DESCRIPTION = 1L;
        private static final long INIT_BIT_OFFICIAL = 2L;
        private static final long INIT_BIT_AUTOMATED = 4L;
        private static final long INIT_BIT_NAME = 8L;
        private static final long INIT_BIT_STAR_COUNT = 16L;
        private long initBits = 31L;
        private String description;
        private boolean official;
        private boolean automated;
        private String name;
        private int starCount;

        private Builder() {
        }

        public final Builder from(ImageSearchResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.description(instance.description());
            this.official(instance.official());
            this.automated(instance.automated());
            this.name(instance.name());
            this.starCount(instance.starCount());
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="is_official")
        public final Builder official(boolean official) {
            this.official = official;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="is_automated")
        public final Builder automated(boolean automated) {
            this.automated = automated;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="star_count")
        public final Builder starCount(int starCount) {
            this.starCount = starCount;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableImageSearchResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableImageSearchResult(this.description, this.official, this.automated, this.name, this.starCount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("official");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("automated");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("starCount");
            }
            return "Cannot build ImageSearchResult, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

