/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.semanticTokens;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SemanticTokensLegend;

public abstract class AbstractcSemanticTokensDataStreamProcessor<T, V> {
    private final Function<Position, Integer> offsetMapper;
    private final Function<String, @Nullable T> tokenTypeMapper;

    public AbstractcSemanticTokensDataStreamProcessor(Function<Position, Integer> offsetMapper, Function<String, @Nullable T> tokenTypeMapper) {
        this.offsetMapper = offsetMapper;
        this.tokenTypeMapper = tokenTypeMapper;
    }

    public final List<V> getTokensData(List<Integer> dataStream, SemanticTokensLegend semanticTokensLegend) {
        ArrayList<V> tokens = new ArrayList<V>(dataStream.size() / 5);
        int idx = 0;
        int prevLine = 0;
        int line = 0;
        int offset = 0;
        int length = 0;
        String tokenType = null;
        for (Integer data : dataStream) {
            switch (idx % 5) {
                case 0: {
                    line += data.intValue();
                    break;
                }
                case 1: {
                    if (line == prevLine) {
                        offset += data.intValue();
                        break;
                    }
                    offset = this.offsetMapper.apply(new Position(line, data.intValue()));
                    break;
                }
                case 2: {
                    length = data;
                    break;
                }
                case 3: {
                    tokenType = this.tokenType(data, semanticTokensLegend.getTokenTypes());
                    break;
                }
                case 4: {
                    prevLine = line;
                    @Nullable V token = this.createTokenData(tokenType == null ? null : (T)this.tokenTypeMapper.apply(tokenType), offset, length, this.tokenModifiers(data, semanticTokensLegend.getTokenModifiers()));
                    if (token == null) break;
                    tokens.add(token);
                }
            }
            ++idx;
        }
        return tokens;
    }

    protected abstract @Nullable V createTokenData(@Nullable T var1, int var2, int var3, List<String> var4);

    private @Nullable String tokenType(Integer data, List<String> legend) {
        try {
            return legend.get(data);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private List<String> tokenModifiers(Integer data, List<String> legend) {
        if (data == 0) {
            return Collections.emptyList();
        }
        BitSet bitSet = BitSet.valueOf(new long[]{data.intValue()});
        ArrayList<String> tokenModifiers = new ArrayList<String>();
        int i = bitSet.nextSetBit(0);
        while (i >= 0) {
            try {
                tokenModifiers.add(legend.get(i));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            i = bitSet.nextSetBit(i + 1);
        }
        return tokenModifiers;
    }
}

