/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.documentLink;

import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerLifecycle;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkParams;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;

public class LSPDocumentLinkPresentationReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
ITextViewerLifecycle {
    private @Nullable ITextViewer viewer;
    private @Nullable CompletableFuture<Void> request;
    private @Nullable IDocument document;

    public void install(@Nullable ITextViewer viewer) {
        this.viewer = viewer;
    }

    public void uninstall() {
        this.viewer = null;
        this.cancel();
    }

    private void underline() {
        ITextViewer theViewer = this.viewer;
        if (theViewer == null) {
            return;
        }
        IDocument document = theViewer.getDocument();
        if (document == null) {
            return;
        }
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri == null) {
            return;
        }
        this.cancel();
        DocumentLinkParams params = new DocumentLinkParams(LSPEclipseUtils.toTextDocumentIdentifier(uri));
        StyledText control = theViewer.getTextWidget();
        if (control != null && !control.isDisposed()) {
            Display display = control.getDisplay();
            this.request = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withFilter(capabilities -> capabilities.getDocumentLinkProvider() != null)).collectAll(languageServer -> languageServer.getTextDocumentService().documentLink(params)).thenAcceptAsync(links -> links.forEach(this::underline), (Executor)display);
        }
    }

    private void underline(@Nullable List<DocumentLink> links) {
        ITextViewer viewer = this.viewer;
        IDocument document = this.document;
        if (document == null || links == null || viewer == null) {
            return;
        }
        for (DocumentLink link : links) {
            try {
                TextPresentation presentation;
                int start = LSPEclipseUtils.toOffset(link.getRange().getStart(), document);
                int end = LSPEclipseUtils.toOffset(link.getRange().getEnd(), document);
                int length = end - start;
                Region linkRegion = new Region(start, length);
                StyleRange styleRange = null;
                StyleRange[] styleRanges = viewer.getTextWidget().getStyleRanges(start, length);
                if (styleRanges != null && styleRanges.length > 0) {
                    StyleRange[] styleRangeArray = styleRanges;
                    int n = styleRanges.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StyleRange s = styleRangeArray[n2];
                        s.underline = true;
                        ++n2;
                    }
                    presentation = new TextPresentation((IRegion)linkRegion, 100);
                    presentation.replaceStyleRanges(styleRanges);
                    viewer.changeTextPresentation(presentation, false);
                    continue;
                }
                styleRange = new StyleRange();
                styleRange.underline = true;
                styleRange.start = start;
                styleRange.length = length;
                presentation = new TextPresentation((IRegion)linkRegion, 100);
                presentation.replaceStyleRange(styleRange);
                viewer.changeTextPresentation(presentation, false);
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
    }

    public void initialReconcile() {
        this.underline();
    }

    private void cancel() {
        if (this.request != null) {
            this.request.cancel(true);
            this.request = null;
        }
    }

    public void setDocument(@Nullable IDocument document) {
        this.document = document;
    }

    public void setProgressMonitor(@Nullable IProgressMonitor monitor) {
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
    }

    public void reconcile(IRegion partition) {
        this.underline();
    }
}

