/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.rpmlint.parser;

import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileParser;

public class RpmlintItem {
    private static final String[] SECTIONS = SpecfileParser.simpleSections;
    private int lineNbr;
    private int severity;
    private String id;
    private String refferedContent;
    private String message;
    private String fileName;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String file) {
        this.fileName = file;
    }

    public int getLineNbr() {
        return this.lineNbr;
    }

    public void setLineNbr(int lineNbr) {
        this.lineNbr = lineNbr;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getRefferedContent() {
        return this.refferedContent;
    }

    public void setRefferedContent(String refferedContent) {
        for (int i = 0; i < SECTIONS.length; ++i) {
            if (refferedContent.startsWith(SECTIONS[i])) {
                this.refferedContent = refferedContent.trim();
                if (this.refferedContent.equals("")) {
                    this.refferedContent = SECTIONS[i];
                }
                i = SECTIONS.length;
                continue;
            }
            this.refferedContent = refferedContent;
        }
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        severity = severity.replace(":", "").trim();
        switch (severity.charAt(0)) {
            case 'I': {
                this.severity = 0;
                break;
            }
            case 'W': {
                this.severity = 1;
                break;
            }
            case 'E': {
                this.severity = 2;
                break;
            }
            default: {
                this.severity = 0;
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("line number: ");
        stringBuilder.append(this.lineNbr);
        stringBuilder.append("\nfile name: ");
        stringBuilder.append(this.fileName);
        stringBuilder.append("\nseverity: ");
        stringBuilder.append(this.severity);
        stringBuilder.append("\nId: ");
        stringBuilder.append(this.id);
        stringBuilder.append("\nrefered content: ");
        stringBuilder.append(this.refferedContent);
        stringBuilder.append("\nmessage: ");
        stringBuilder.append(this.getMessage());
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

