/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.model;

import java.util.LinkedList;
import org.eclipse.linuxtools.internal.gcov.model.TreeElement;

public abstract class AbstractTreeElement
implements TreeElement {
    private static final long serialVersionUID = -4911602250295116203L;
    private final TreeElement parent;
    private final LinkedList<TreeElement> children = new LinkedList();
    private final String name;
    private final int totalLines;
    private final int executedLines;
    private final int instrumentedLines;

    public AbstractTreeElement(TreeElement parent, String name, int totalLines, int executedLines, int instrumentedLines) {
        this.parent = parent;
        this.name = name;
        this.totalLines = totalLines;
        this.executedLines = executedLines;
        this.instrumentedLines = instrumentedLines;
    }

    @Override
    public TreeElement getParent() {
        return this.parent;
    }

    @Override
    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    @Override
    public LinkedList<? extends TreeElement> getChildren() {
        return this.children;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TreeElement getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    @Override
    public int getExecutedLines() {
        return this.executedLines;
    }

    @Override
    public int getInstrumentedLines() {
        return this.instrumentedLines;
    }

    @Override
    public float getCoveragePercentage() {
        if (this.instrumentedLines != 0) {
            return 100.0f * (float)this.executedLines / (float)this.instrumentedLines;
        }
        return 0.0f;
    }

    public void addChild(TreeElement child) {
        this.children.add(child);
    }

    @Override
    public int getTotalLines() {
        return this.totalLines;
    }
}

