/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.remotese.nativese.method;

import org.eclipse.keyple.plugin.remotese.nativese.NativeReaderServiceImpl;
import org.eclipse.keyple.plugin.remotese.rm.RemoteMethod;
import org.eclipse.keyple.plugin.remotese.rm.RemoteMethodExecutor;
import org.eclipse.keyple.plugin.remotese.transport.KeypleDtoHelper;
import org.eclipse.keyple.plugin.remotese.transport.json.JsonParser;
import org.eclipse.keyple.plugin.remotese.transport.model.KeypleDto;
import org.eclipse.keyple.plugin.remotese.transport.model.TransportDto;
import org.eclipse.keyple.seproxy.exception.KeypleReaderException;
import org.eclipse.keyple.seproxy.message.ProxyReader;
import org.eclipse.keyple.seproxy.message.SeRequestSet;
import org.eclipse.keyple.seproxy.message.SeResponseSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmTransmitExecutor
implements RemoteMethodExecutor {
    private static final Logger logger = LoggerFactory.getLogger(RmTransmitExecutor.class);
    private final NativeReaderServiceImpl nativeReaderService;

    public RmTransmitExecutor(NativeReaderServiceImpl nativeReaderService) {
        this.nativeReaderService = nativeReaderService;
    }

    @Override
    public TransportDto execute(TransportDto transportDto) {
        KeypleDto keypleDto = transportDto.getKeypleDTO();
        TransportDto out = null;
        SeResponseSet seResponseSet = null;
        SeRequestSet seRequestSet = (SeRequestSet)JsonParser.getGson().fromJson(keypleDto.getBody(), SeRequestSet.class);
        String nativeReaderName = keypleDto.getNativeReaderName();
        logger.trace("Execute locally seRequestSet : {}", (Object)seRequestSet);
        try {
            ProxyReader reader = this.nativeReaderService.findLocalReader(nativeReaderName);
            seResponseSet = reader.transmitSet(seRequestSet);
            String parseBody = JsonParser.getGson().toJson((Object)seResponseSet, SeResponseSet.class);
            out = transportDto.nextTransportDTO(new KeypleDto(RemoteMethod.READER_TRANSMIT.getName(), parseBody, false, keypleDto.getSessionId(), nativeReaderName, keypleDto.getVirtualReaderName(), keypleDto.getNodeId()));
        }
        catch (KeypleReaderException e) {
            out = transportDto.nextTransportDTO(KeypleDtoHelper.ExceptionDTO(RemoteMethod.READER_TRANSMIT.getName(), e, keypleDto.getSessionId(), nativeReaderName, keypleDto.getVirtualReaderName(), keypleDto.getNodeId()));
        }
        return out;
    }
}

