/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.remotese.nativese.method;

import com.google.gson.JsonObject;
import org.eclipse.keyple.plugin.remotese.exception.KeypleRemoteException;
import org.eclipse.keyple.plugin.remotese.rm.RemoteMethod;
import org.eclipse.keyple.plugin.remotese.rm.RemoteMethodTx;
import org.eclipse.keyple.plugin.remotese.transport.KeypleDtoHelper;
import org.eclipse.keyple.plugin.remotese.transport.json.JsonParser;
import org.eclipse.keyple.plugin.remotese.transport.model.KeypleDto;
import org.eclipse.keyple.seproxy.exception.KeypleReaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmDisconnectReaderTx
extends RemoteMethodTx<Boolean> {
    private static final Logger logger = LoggerFactory.getLogger(RmDisconnectReaderTx.class);

    public RmDisconnectReaderTx(String sessionId, String nativeReaderName, String slaveNodeId) {
        super(sessionId, nativeReaderName, "", slaveNodeId);
    }

    @Override
    public Boolean parseResponse(KeypleDto keypleDto) throws KeypleRemoteException {
        if (KeypleDtoHelper.containsException(keypleDto).booleanValue()) {
            logger.trace("KeypleDto contains an exception: {}", (Object)keypleDto);
            KeypleReaderException ex = (KeypleReaderException)JsonParser.getGson().fromJson(keypleDto.getBody(), KeypleReaderException.class);
            throw new KeypleRemoteException("An exception occurs while calling the remote method disconnectReader", (Throwable)ex);
        }
        JsonObject body = (JsonObject)JsonParser.getGson().fromJson(keypleDto.getBody(), JsonObject.class);
        return body.get("status").getAsBoolean();
    }

    @Override
    public KeypleDto dto() {
        JsonObject body = new JsonObject();
        body.addProperty("sessionId", this.sessionId);
        return new KeypleDto(RemoteMethod.READER_DISCONNECT.getName(), JsonParser.getGson().toJson((Object)body, JsonObject.class), true, null, this.nativeReaderName, null, this.clientNodeId);
    }
}

