/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.seproxy.event;

import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class PluginEvent {
    private final String pluginName;
    private SortedSet<String> readerNames = new TreeSet<String>();
    private final EventType eventType;

    public PluginEvent(String pluginName, String readerName, EventType eventType) {
        this.pluginName = pluginName;
        this.readerNames.add(readerName);
        this.eventType = eventType;
    }

    public PluginEvent(String pluginName, Set<String> readerNames, EventType eventType) {
        this.pluginName = pluginName;
        this.readerNames.addAll(readerNames);
        this.eventType = eventType;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public SortedSet<String> getReaderNames() {
        return this.readerNames;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public static enum EventType {
        READER_CONNECTED("Reader connected"),
        READER_DISCONNECTED("Reader disconnected");

        private String name;

        private EventType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

