/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.seproxy.event;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.keyple.seproxy.SeReader;
import org.eclipse.keyple.seproxy.event.DefaultSelectionRequest;
import org.eclipse.keyple.seproxy.event.ReaderEvent;
import org.eclipse.keyple.util.Observable;

public interface ObservableReader
extends SeReader {
    public void addObserver(ReaderObserver var1);

    public void removeObserver(ReaderObserver var1);

    public void notifyObservers(ReaderEvent var1);

    public void setDefaultSelectionRequest(DefaultSelectionRequest var1, NotificationMode var2);

    public static enum NotificationMode {
        ALWAYS("always"),
        MATCHED_ONLY("matched_only");

        private String name;
        private static final Map<String, NotificationMode> lookup;

        private NotificationMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static NotificationMode get(String name) {
            return lookup.get(name);
        }

        static {
            lookup = new HashMap<String, NotificationMode>();
            for (NotificationMode env : NotificationMode.values()) {
                lookup.put(env.getName(), env);
            }
        }
    }

    public static interface ReaderObserver
    extends Observable.Observer<ReaderEvent> {
    }
}

