/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.meta.model.processes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BooleanConnector implements Enumerator
{
    AND_LITERAL(0, "AND", "&&"),
    XOR_LITERAL(1, "XOR", "||");

    public static final String copyright = "Copyright (c) 2005-2012  Eclipse Java Workflow Tooling (JWT) Project <www.eclipse.org/jwt>";
    public static final int AND = 0;
    public static final int XOR = 1;
    private static final BooleanConnector[] VALUES_ARRAY;
    public static final List<BooleanConnector> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BooleanConnector[]{AND_LITERAL, XOR_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BooleanConnector get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BooleanConnector result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BooleanConnector getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BooleanConnector result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BooleanConnector get(int value) {
        switch (value) {
            case 0: {
                return AND_LITERAL;
            }
            case 1: {
                return XOR_LITERAL;
            }
        }
        return null;
    }

    private BooleanConnector(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

