/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.parts.processes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPolicy;
import org.eclipse.jwt.meta.model.processes.ActivityNode;
import org.eclipse.jwt.meta.model.processes.impl.ActivityEdgeImpl;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.parts.core.GraphicalElementEditPartHelper;
import org.eclipse.jwt.we.parts.core.NamedElementEditPart;
import org.eclipse.jwt.we.parts.processes.policies.ActivityNodeGraphicalNodeEditPolicy;

public class ActivityNodeEditPart
extends NamedElementEditPart {
    private static final Logger logger = Logger.getLogger(ActivityNodeEditPart.class);
    private int maximumInEdges = Integer.MAX_VALUE;
    private int maximumOutEdges = Integer.MAX_VALUE;
    private final GraphicalElementEditPartHelper graphicalElementEditPartHelper = new GraphicalElementEditPartHelper(this);

    public Class getModelClass() {
        return ActivityNode.class;
    }

    protected int getMaximumInActivityEdges() {
        return this.maximumInEdges;
    }

    public void setMaximumInActivityEdges(int maximumInEdges) {
        this.maximumInEdges = maximumInEdges;
        EditPolicy graphicalEditPolicy = this.getEditPolicy("GraphicalNodeEditPolicy");
        if (graphicalEditPolicy != null && graphicalEditPolicy instanceof ActivityNodeGraphicalNodeEditPolicy) {
            ((ActivityNodeGraphicalNodeEditPolicy)graphicalEditPolicy).setMaximumInActivityEdges(maximumInEdges);
        }
    }

    public int getMaximumOutActivityEdges() {
        return this.maximumOutEdges;
    }

    public void setMaximumOutActivityEdges(int maximumOutEdges) {
        this.maximumOutEdges = maximumOutEdges;
        EditPolicy graphicalEditPolicy = this.getEditPolicy("GraphicalNodeEditPolicy");
        if (graphicalEditPolicy != null && graphicalEditPolicy instanceof ActivityNodeGraphicalNodeEditPolicy) {
            ((ActivityNodeGraphicalNodeEditPolicy)graphicalEditPolicy).setMaximumOutActivityEdges(maximumOutEdges);
        }
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ActivityNodeGraphicalNodeEditPolicy(this.getMaximumInActivityEdges(), this.getMaximumOutActivityEdges()));
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        this.graphicalElementEditPartHelper.notifyChanged(notification);
        int featureId = notification.getFeatureID(ActivityNode.class);
        block0 : switch (notification.getEventType()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                switch (featureId) {
                    case 3: {
                        this.refreshTargetConnections();
                        break block0;
                    }
                    case 4: {
                        this.refreshSourceConnections();
                    }
                }
            }
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.graphicalElementEditPartHelper.refreshVisuals();
    }

    protected List getModelSourceConnections() {
        EList objectlist = ((ActivityNode)this.getModel()).getOut();
        ArrayList returnlist = new ArrayList();
        Views myviews = Views.getInstance();
        for (Object obj : objectlist) {
            ActivityEdgeImpl aei = (ActivityEdgeImpl)obj;
            ActivityNode targetActivityNode = aei.basicGetTarget();
            if (targetActivityNode == null) {
                returnlist.add(obj);
                continue;
            }
            EClass basicclass = aei.basicGetTarget().eClass();
            if (!myviews.displayObject((EObject)basicclass)) continue;
            returnlist.add(obj);
        }
        return returnlist;
    }

    protected List getModelTargetConnections() {
        EList objectlist = ((ActivityNode)this.getModel()).getIn();
        ArrayList returnlist = new ArrayList();
        Views myviews = Views.getInstance();
        for (Object obj : objectlist) {
            ActivityEdgeImpl aei = (ActivityEdgeImpl)obj;
            ActivityNode sourceActivityNode = aei.basicGetSource();
            if (sourceActivityNode == null) {
                returnlist.add(obj);
                continue;
            }
            EClass basicclass = aei.basicGetSource().eClass();
            if (!myviews.displayObject((EObject)basicclass)) continue;
            returnlist.add(obj);
        }
        return returnlist;
    }

    protected ConnectionAnchor createConnectionAnchor() {
        return new ChopboxAnchor(this.getFigure());
    }
}

