/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.parts.processes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.jwt.meta.model.processes.Action;
import org.eclipse.jwt.meta.model.processes.Scope;
import org.eclipse.jwt.we.figures.processes.DiamondAnchor;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.util.EMFHelper;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.model.view.Diagram;
import org.eclipse.jwt.we.model.view.ReferenceEdge;
import org.eclipse.jwt.we.parts.processes.ActivityEdgeEditPart;
import org.eclipse.jwt.we.parts.processes.ExecutableNodeEditPart;
import org.eclipse.jwt.we.parts.processes.policies.ActionGraphicalNodeEditPolicy;
import org.eclipse.jwt.we.parts.view.ReferenceEdgeEditPart;

public class ActionEditPart
extends ExecutableNodeEditPart {
    private static final Logger logger = Logger.getLogger(ActionEditPart.class);
    private static final int MAXIMUM_IN_EDGES = 1;
    private static final int MAXIMUM_OUT_EDGES = 1;

    public ActionEditPart() {
        this.setMaximumInActivityEdges(1);
        this.setMaximumOutActivityEdges(1);
    }

    public Class getModelClass() {
        return Action.class;
    }

    protected List getModelSourceConnections() {
        BasicEList conns = new BasicEList((Collection)super.getModelSourceConnections());
        EList<ReferenceEdge> referenceedges = EMFHelper.getReferenceEdgesForAction(this.getWEEditor(), (Action)this.getModel());
        ArrayList newreferencelist = new ArrayList();
        for (Object obj : referenceedges) {
            ReferenceEdge refedge = (ReferenceEdge)obj;
            if (refedge.getReference() == null || refedge.getReference().getReference() == null || !Views.getInstance().displayObject((EObject)refedge.getReference().getReference().eClass())) continue;
            newreferencelist.add(obj);
        }
        conns.addAll(newreferencelist);
        return conns;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        if (connection instanceof ActivityEdgeEditPart) {
            return this.createActivityEdgeConnectionAnchor();
        }
        if (connection instanceof ReferenceEdgeEditPart) {
            return this.createReferenceEdgeConnectionAnchor();
        }
        return super.getSourceConnectionAnchor(connection);
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.createReferenceEdgeConnectionAnchor();
    }

    protected Scope getScope() {
        return (Scope)((EObject)this.getModel()).eContainer();
    }

    protected Action getAction() {
        return (Action)this.getModel();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ActionGraphicalNodeEditPolicy(this.getMaximumInActivityEdges(), this.getMaximumOutActivityEdges()));
    }

    protected IFigure createFigure() {
        this.setDoDirectEdit(true);
        return super.createFigure();
    }

    protected ConnectionAnchor createConnectionAnchor() {
        return this.createActivityEdgeConnectionAnchor();
    }

    protected ConnectionAnchor createActivityEdgeConnectionAnchor() {
        return new DiamondAnchor(this.getFigure());
    }

    protected ConnectionAnchor createReferenceEdgeConnectionAnchor() {
        return new ChopboxAnchor(this.getFigure());
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        int featureId = notification.getFeatureID(Diagram.class);
        switch (featureId) {
            case 3: {
                this.refreshSourceConnections();
            }
        }
    }
}

