/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.commands.view;

import java.util.Collections;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jwt.meta.model.application.Application;
import org.eclipse.jwt.meta.model.core.ReferenceableElement;
import org.eclipse.jwt.meta.model.data.Data;
import org.eclipse.jwt.meta.model.organisations.Role;
import org.eclipse.jwt.meta.model.processes.Action;
import org.eclipse.jwt.meta.model.processes.ProcessesPackage;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.util.EMFHelper;
import org.eclipse.jwt.we.model.view.EdgeDirection;
import org.eclipse.jwt.we.model.view.Reference;
import org.eclipse.jwt.we.model.view.ReferenceEdge;
import org.eclipse.jwt.we.model.view.ViewFactory;
import org.eclipse.jwt.we.model.view.ViewPackage;

public class CreateReferenceEdgeCommand
extends AbstractCommand {
    private WEEditor weeditor;
    private EditingDomain editingDomain;
    private Object conSource;
    private Object conTarget;
    private int direction;
    private Command removePreviousEntryCommand;
    private Command setFeatureCommand;
    private CompoundCommand addReferenceEdgeCommand;
    private boolean skipCanExecute = false;

    public CreateReferenceEdgeCommand(WEEditor weeditor, EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
        this.weeditor = weeditor;
    }

    public void setSkipCanExecute(boolean skipCanExecute) {
        this.skipCanExecute = skipCanExecute;
    }

    public void setSource(Object source) {
        this.conSource = source;
    }

    public void setTarget(Object target) {
        this.conTarget = target;
    }

    public void setDirection(int direc) {
        this.direction = direc;
    }

    private Action getAction() {
        if (this.conSource instanceof Action) {
            return (Action)this.conSource;
        }
        if (this.conTarget instanceof Action) {
            return (Action)this.conTarget;
        }
        return null;
    }

    private Reference getReference() {
        if (this.conSource instanceof Reference) {
            return (Reference)this.conSource;
        }
        if (this.conTarget instanceof Reference) {
            return (Reference)this.conTarget;
        }
        return null;
    }

    private ReferenceableElement getRefElem() {
        if (this.getReference() != null) {
            return this.getReference().getReference();
        }
        return null;
    }

    public boolean checkConnection() {
        if (this.getAction() == null || this.getReference() == null) {
            return false;
        }
        if (this.getRefElem() instanceof Application || this.getRefElem() instanceof Role) {
            for (ReferenceEdge refEdge : this.getReference().getReferenceEdges()) {
                if (!refEdge.getAction().equals(this.getAction()) || !refEdge.getReference().equals(this.getReference())) continue;
                return false;
            }
        }
        if (this.getRefElem() instanceof Data) {
            boolean inputPresent = this.getAction().getInputs().contains((Object)this.getRefElem());
            boolean outputPresent = this.getAction().getOutputs().contains((Object)this.getRefElem());
            if (inputPresent && outputPresent) {
                return false;
            }
            if (inputPresent && this.direction == 0) {
                return false;
            }
            if (outputPresent && this.direction == 1) {
                return false;
            }
            if (inputPresent && this.direction == 1 || outputPresent && this.direction == 0) {
                for (ReferenceEdge edge : EMFHelper.getReferenceEdgesForAction(this.weeditor, this.getAction())) {
                    if (edge.getReference().getReference() != this.getRefElem() || edge.getAction() == this.getAction() && edge.getReference() == this.getReference()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean canExecute() {
        if (this.skipCanExecute) {
            return true;
        }
        if (this.editingDomain == null) {
            return false;
        }
        return this.checkConnection();
    }

    private EdgeDirection getDirectionOfExistingEdge() {
        if (this.getRefElem() instanceof Data) {
            boolean input = this.getAction().getInputs().contains((Object)this.getRefElem());
            boolean output = this.getAction().getOutputs().contains((Object)this.getRefElem());
            if (input && output) {
                return EdgeDirection.INOUT;
            }
            if (input) {
                return EdgeDirection.IN;
            }
            if (output) {
                return EdgeDirection.OUT;
            }
        }
        return EdgeDirection.DEFAULT;
    }

    private ReferenceEdge findRefEdge(ReferenceableElement refElem) {
        for (ReferenceEdge refEdge : EMFHelper.getReferenceEdgesForAction(this.weeditor, this.getAction())) {
            if (refEdge.getReference().getReference() != refElem) continue;
            return refEdge;
        }
        return null;
    }

    private EStructuralFeature getFeature() {
        EReference feature = null;
        if (this.getRefElem() instanceof Application) {
            feature = ProcessesPackage.eINSTANCE.getAction_ExecutedBy();
        } else if (this.getRefElem() instanceof Role) {
            feature = ProcessesPackage.eINSTANCE.getAction_PerformedBy();
        } else if (this.getRefElem() instanceof Data && this.direction == 0) {
            feature = ProcessesPackage.Literals.ACTION__INPUTS;
        } else if (this.getRefElem() instanceof Data && this.direction == 1) {
            feature = ProcessesPackage.Literals.ACTION__OUTPUTS;
        }
        return feature;
    }

    private CompoundCommand createReferenceEdgeCommand(boolean existingInputEdge, boolean existingOutputEdge, EStructuralFeature feature) {
        ReferenceEdge refEdge = ViewFactory.eINSTANCE.createReferenceEdge();
        EdgeDirection dir = null;
        if (!(this.getRefElem() instanceof Data)) {
            dir = EdgeDirection.DEFAULT;
        } else if (existingInputEdge && feature == ProcessesPackage.Literals.ACTION__OUTPUTS || existingOutputEdge && feature == ProcessesPackage.Literals.ACTION__INPUTS) {
            dir = EdgeDirection.INOUT;
        } else if (feature == ProcessesPackage.Literals.ACTION__INPUTS) {
            dir = EdgeDirection.IN;
        } else if (feature == ProcessesPackage.Literals.ACTION__OUTPUTS) {
            dir = EdgeDirection.OUT;
        }
        CompoundCommand addRefEdgeCommand = new CompoundCommand();
        addRefEdgeCommand = new CompoundCommand();
        addRefEdgeCommand.append(SetCommand.create((EditingDomain)this.editingDomain, (Object)refEdge, (Object)ViewPackage.Literals.REFERENCE_EDGE__REFERENCE, (Object)this.getReference()));
        addRefEdgeCommand.append(SetCommand.create((EditingDomain)this.editingDomain, (Object)refEdge, (Object)ViewPackage.Literals.REFERENCE_EDGE__ACTION, (Object)this.getAction()));
        addRefEdgeCommand.append(SetCommand.create((EditingDomain)this.editingDomain, (Object)refEdge, (Object)ViewPackage.Literals.REFERENCE_EDGE__DIRECTION, (Object)((Object)dir)));
        addRefEdgeCommand.append(SetCommand.create((EditingDomain)this.editingDomain, (Object)refEdge, (Object)ViewPackage.Literals.REFERENCE_EDGE__CONTAINED_IN, (Object)this.getAction().eContainer()));
        addRefEdgeCommand.append(AddCommand.create((EditingDomain)this.editingDomain, (Object)this.weeditor.getDiagramData(), (Object)ViewPackage.Literals.DIAGRAM__REFERENCE_EDGES, Collections.singleton(refEdge)));
        return addRefEdgeCommand;
    }

    public void execute() {
        this.setFeatureCommand = null;
        this.removePreviousEntryCommand = null;
        this.addReferenceEdgeCommand = null;
        boolean existingInputEdge = this.getDirectionOfExistingEdge() == EdgeDirection.IN;
        boolean existingOutputEdge = this.getDirectionOfExistingEdge() == EdgeDirection.OUT;
        EStructuralFeature feature = this.getFeature();
        if ((feature == ProcessesPackage.eINSTANCE.getAction_ExecutedBy() || feature == ProcessesPackage.eINSTANCE.getAction_PerformedBy()) && this.getAction().eGet(feature) != null) {
            this.removePreviousEntryCommand = new DeleteCommand(this.editingDomain, Collections.singleton(this.findRefEdge((ReferenceableElement)this.getAction().eGet(feature))));
        }
        if (existingInputEdge || existingOutputEdge) {
            this.removePreviousEntryCommand = new DeleteCommand(this.editingDomain, Collections.singleton(this.findRefEdge(this.getRefElem())));
        }
        if (feature.isMany()) {
            if (existingInputEdge || existingOutputEdge) {
                this.setFeatureCommand = new AddCommand(this.editingDomain, (EObject)this.getAction(), (EStructuralFeature)ProcessesPackage.Literals.ACTION__INPUTS, (Object)this.getRefElem());
                this.setFeatureCommand = this.setFeatureCommand.chain((Command)new AddCommand(this.editingDomain, (EObject)this.getAction(), (EStructuralFeature)ProcessesPackage.Literals.ACTION__OUTPUTS, (Object)this.getRefElem()));
            } else {
                this.setFeatureCommand = new AddCommand(this.editingDomain, (EObject)this.getAction(), feature, (Object)this.getRefElem());
            }
        } else {
            this.setFeatureCommand = new SetCommand(this.editingDomain, (EObject)this.getAction(), feature, (Object)this.getRefElem());
        }
        this.addReferenceEdgeCommand = this.createReferenceEdgeCommand(existingInputEdge, existingOutputEdge, feature);
        boolean canExecute = this.addReferenceEdgeCommand.canExecute();
        if (this.removePreviousEntryCommand != null) {
            boolean bl = canExecute = canExecute && this.removePreviousEntryCommand.canExecute();
        }
        if (canExecute) {
            if (this.removePreviousEntryCommand != null) {
                this.removePreviousEntryCommand.execute();
            }
            if (this.setFeatureCommand.canExecute()) {
                this.setFeatureCommand.execute();
                this.addReferenceEdgeCommand.execute();
            } else if (this.removePreviousEntryCommand != null) {
                this.removePreviousEntryCommand.undo();
            }
        }
    }

    public void undo() {
        this.addReferenceEdgeCommand.undo();
        this.setFeatureCommand.undo();
        if (this.removePreviousEntryCommand != null) {
            this.removePreviousEntryCommand.undo();
        }
    }

    public void redo() {
        if (this.removePreviousEntryCommand != null) {
            this.removePreviousEntryCommand.redo();
        }
        this.setFeatureCommand.redo();
        this.addReferenceEdgeCommand.redo();
    }

    public void dispose() {
        super.dispose();
        if (this.removePreviousEntryCommand != null) {
            this.removePreviousEntryCommand.dispose();
        }
        if (this.setFeatureCommand != null) {
            this.setFeatureCommand.dispose();
        }
        if (this.addReferenceEdgeCommand != null) {
            this.addReferenceEdgeCommand.dispose();
        }
    }
}

