/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit.html.config;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.toolkit.base.config.AbstractOSAUTConfiguration;
import org.eclipse.jubula.toolkit.html.Browser;

public class HTMLAUTConfiguration
extends AbstractOSAUTConfiguration {
    @NonNull
    private URL m_url;
    @NonNull
    private Browser m_browser;
    @Nullable
    private String m_browserPath;
    private boolean m_singleWindow = true;
    @Nullable
    private String m_idAttributeName;

    public HTMLAUTConfiguration(@Nullable String name, @NonNull String autID, @NonNull String workingDir, @NonNull String sURL, @NonNull Browser browser, @Nullable String browserPath, boolean singleWindow, @Nullable String idAttributeName) throws MalformedURLException {
        super(name, autID, workingDir);
        Validate.notNull((Object)sURL, (String)"The URL must not be null");
        this.m_url = new URL(sURL);
        Validate.notNull((Object)browser, (String)"The Browser must not be null");
        this.m_browser = browser;
        if (browserPath != null && Browser.InternetExplorer.equals((Object)browser)) {
            throw new IllegalArgumentException("Setting of browser path is not supported for " + browser);
        }
        this.m_browserPath = browserPath;
        this.m_singleWindow = singleWindow;
        this.m_idAttributeName = idAttributeName;
        this.add("AUT_ARGUMENTS", sURL);
        this.add("BROWSER", browser.toString());
        this.add("BROWSER_PATH", browserPath);
        this.add("SINGLE_WINDOW_MODE", String.valueOf(singleWindow));
        this.add("WEB_ID_TAG", idAttributeName);
        this.add("toolkitID", "com.bredexsw.guidancer.HtmlToolkitPlugin");
    }

    @NonNull
    public URL getUrl() {
        return this.m_url;
    }

    @NonNull
    public Browser getBrowser() {
        return this.m_browser;
    }

    @Nullable
    public String getBrowserPath() {
        return this.m_browserPath;
    }

    public boolean isSingleWindow() {
        return this.m_singleWindow;
    }

    @Nullable
    public String getIdAttributeName() {
        return this.m_idAttributeName;
    }
}

