/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.queries;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQueries;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;

public class PDisjunction {
    private ImmutableSet<PBody> bodies;
    private PQuery query;

    public PDisjunction(Set<PBody> bodies) {
        this(bodies.iterator().next().getPattern(), bodies);
    }

    public PDisjunction(PQuery query, Set<PBody> bodies) {
        this.query = query;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (PBody body : bodies) {
            body.setContainerDisjunction(this);
            builder.add((Object)body);
        }
        this.bodies = builder.build();
    }

    public Set<PBody> getBodies() {
        return this.bodies;
    }

    public PQuery getQuery() {
        return this.query;
    }

    public Set<PQuery> getDirectReferredQueries() {
        Iterable queries = Iterables.concat((Iterable)Iterables.transform(this.getBodies(), PQueries.directlyReferencedQueriesFunction()));
        return Sets.newHashSet((Iterable)queries);
    }

    public Set<PQuery> getAllReferredQueries() {
        HashSet processedQueries = Sets.newHashSet((Object[])new PQuery[]{this.getQuery()});
        Set<PQuery> foundQueries = this.getDirectReferredQueries();
        HashSet newQueries = Sets.newHashSet(foundQueries);
        while (!processedQueries.containsAll(newQueries)) {
            PQuery query = (PQuery)newQueries.iterator().next();
            processedQueries.add(query);
            newQueries.remove(query);
            Set<PQuery> referred = query.getDirectReferredQueries();
            referred.removeAll(processedQueries);
            foundQueries.addAll(referred);
            newQueries.addAll(referred);
        }
        return foundQueries;
    }

    public boolean isMutable() {
        for (PBody body : this.bodies) {
            if (body.isMutable()) continue;
            return false;
        }
        return true;
    }
}

