/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction.helpers;

import java.util.Collection;
import java.util.Set;
import org.eclipse.incquery.runtime.rete.collections.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.construction.psystem.ITypeInfoProviderConstraint;
import org.eclipse.incquery.runtime.rete.construction.psystem.PConstraint;
import org.eclipse.incquery.runtime.rete.construction.psystem.PVariable;
import org.eclipse.incquery.runtime.rete.matcher.IPatternMatcherContext;

public class TypeHelper {
    public static Set<Object> inferTypes(PVariable pVariable, Set<PConstraint> constraints) {
        Set<Object> inferredTypes = CollectionsFactory.getSet();
        for (PConstraint pConstraint : constraints) {
            Object typeInfo;
            if (!(pConstraint instanceof ITypeInfoProviderConstraint) || (typeInfo = ((ITypeInfoProviderConstraint)((Object)pConstraint)).getTypeInfo(pVariable)) == ITypeInfoProviderConstraint.TypeInfoSpecials.NO_TYPE_INFO_PROVIDED) continue;
            inferredTypes.add(typeInfo);
        }
        return inferredTypes;
    }

    public static Set<Object> typeClosure(Set<Object> typesToClose, IPatternMatcherContext<?> context) {
        Set<Object> closure;
        Set<Object> delta = closure = CollectionsFactory.getSet(typesToClose);
        while (!delta.isEmpty()) {
            Set<Object> newTypes = CollectionsFactory.getSet();
            for (Object deltaType : delta) {
                Collection<Object> directSupertypes;
                if (deltaType instanceof ITypeInfoProviderConstraint.TypeInfoSpecials) continue;
                if (context.isUnaryType(deltaType)) {
                    newTypes.add((Object)ITypeInfoProviderConstraint.TypeInfoSpecials.ANY_UNARY);
                }
                if (context.isTernaryEdgeType(deltaType)) {
                    newTypes.add((Object)ITypeInfoProviderConstraint.TypeInfoSpecials.ANY_TERNARY);
                }
                if ((directSupertypes = context.enumerateDirectSupertypes(deltaType)) == null) continue;
                newTypes.addAll(directSupertypes);
            }
            newTypes.removeAll(closure);
            delta = newTypes;
            closure.addAll(delta);
        }
        return closure;
    }

    public static Set<Object> subsumeTypes(Set<Object> subsumableTypes, Set<Object> subsumingTypes, IPatternMatcherContext<?> context) {
        Set<Object> closure = TypeHelper.typeClosure(subsumingTypes, context);
        Set<Object> subsumed = CollectionsFactory.getSet(subsumableTypes);
        subsumed.removeAll(closure);
        return subsumed;
    }
}

