/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction;

import org.eclipse.incquery.runtime.rete.construction.Buildable;
import org.eclipse.incquery.runtime.rete.construction.CodegenRecordingCoordinator;
import org.eclipse.incquery.runtime.rete.construction.Stub;
import org.eclipse.incquery.runtime.rete.matcher.IPatternMatcherContext;
import org.eclipse.incquery.runtime.rete.tuple.FlatTuple;
import org.eclipse.incquery.runtime.rete.tuple.LeftInheritanceTuple;
import org.eclipse.incquery.runtime.rete.tuple.Tuple;
import org.eclipse.incquery.runtime.rete.tuple.TupleMask;

public abstract class CodegenRecorderBuildable<PatternDescription>
implements Buildable<PatternDescription, String, String> {
    public CodegenRecordingCoordinator<PatternDescription> coordinator;
    public PatternDescription effort;
    public String myName;
    public String baseName;
    public String indent;

    public CodegenRecorderBuildable(CodegenRecordingCoordinator<PatternDescription> coordinator, PatternDescription effort, String indent, String baseName, String instanceSuffix) {
        this.coordinator = coordinator;
        this.effort = effort;
        this.indent = indent;
        this.baseName = baseName;
        this.myName = String.valueOf(baseName) + instanceSuffix;
    }

    @Override
    public void reinitialize() {
        throw new UnsupportedOperationException();
    }

    protected String prettyPrintStringArray(String[] elements, String separator) {
        if (elements.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(elements[0]);
        int i = 1;
        while (i < elements.length) {
            result.append(", ");
            result.append(elements[i]);
            ++i;
        }
        return result.toString();
    }

    protected String prettyPrintStringArray(String[] elements) {
        return this.prettyPrintStringArray(elements, ", ");
    }

    protected String prettyPrintIntArray(int[] elements, String separator) {
        if (elements.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(elements[0]);
        int i = 1;
        while (i < elements.length) {
            result.append(", ");
            result.append(elements[i]);
            ++i;
        }
        return result.toString();
    }

    protected String prettyPrintIntArray(int[] elements) {
        return this.prettyPrintIntArray(elements, ", ");
    }

    protected String prettyPrintObjectArray(Object[] elements, String separator, boolean strict) {
        if (elements.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(this.gen(elements[0], strict));
        int i = 1;
        while (i < elements.length) {
            result.append(separator);
            result.append(this.gen(elements[i], strict));
            ++i;
        }
        return result.toString();
    }

    protected String prettyPrintObjectArray(Object[] constantValues, boolean strict) {
        return this.prettyPrintObjectArray(constantValues, ", ", strict);
    }

    protected void emitLine(String line) {
        this.coordinator.emitPatternBuilderLine(this.effort, this.indent, line);
    }

    protected String call(String methodName, String arguments) {
        return String.valueOf(this.myName) + "." + methodName + "(" + arguments + ")";
    }

    protected String call(String methodName, String[] arguments) {
        return this.call(methodName, this.prettyPrintStringArray(arguments));
    }

    protected String emitFunctionCall(String resultType, String methodName, String arguments) {
        return this.declareNewValue(resultType, this.call(methodName, arguments));
    }

    protected String emitFunctionCall(String resultType, String methodName, String[] arguments) {
        return this.declareNewValue(resultType, this.call(methodName, arguments));
    }

    protected void emitProcedureCall(String methodName, String arguments) {
        this.emitLine(String.valueOf(this.call(methodName, arguments)) + ";");
    }

    protected void emitProcedureCall(String methodName, String[] arguments) {
        this.emitLine(String.valueOf(this.call(methodName, arguments)) + ";");
    }

    protected void declareNew(String type, String identifier, String value, boolean isFinal) {
        this.emitLine(String.valueOf(isFinal ? "final " : "") + type + " " + identifier + " = " + value + ";");
    }

    protected String declareNewValue(String type, String value) {
        String name = this.coordinator.newVariableIdentifier();
        this.declareNew(type, name, value, true);
        return name;
    }

    protected String declareNewBuildable(String value) {
        String name = this.coordinator.newBuildableIdentifier();
        this.declareNew(this.coordinator.buildableType, name, value, true);
        return name;
    }

    protected String gen(Stub<String> stub) {
        return stub.getHandle();
    }

    protected String gen(boolean bool) {
        return bool ? "true" : "false";
    }

    protected String gen(Integer integer) {
        return integer == null ? "null" : integer.toString();
    }

    protected String gen(int[] ints) {
        return "new int[] {" + this.prettyPrintIntArray(ints) + "}";
    }

    protected String gen(TupleMask mask) {
        return this.declareNewValue("TupleMask", "new TupleMask(" + this.gen(mask.indices) + ", " + this.gen(mask.sourceWidth) + ")");
    }

    protected String gen(Object o, boolean strict) {
        if (o instanceof Number) {
            return o.toString();
        }
        if (o instanceof String) {
            return "\"" + o.toString() + "\"";
        }
        if (!strict) {
            return "\"" + o.toString() + "\"";
        }
        throw new UnsupportedOperationException("Cannot currently generate code from an " + o.getClass() + " instance: " + o.toString());
    }

    protected String gen(Object[] o, boolean strict) {
        return "new Object[] {" + this.prettyPrintObjectArray(o, strict) + "}";
    }

    protected String gen(Tuple tuple, boolean strict) {
        return "new FlatTuple(" + this.gen(tuple.getElements(), strict) + ")";
    }

    public String genCalibrationElement(Object calibrationElement) {
        return this.gen(calibrationElement, false);
    }

    public abstract String genUnaryType(Object var1);

    public abstract String genTernaryEdgeType(Object var1);

    public abstract String genBinaryEdgeType(Object var1);

    public abstract String genPattern(PatternDescription var1);

    public String declareNextContainerVariable() {
        return this.declareNewBuildable(this.call("getNextContainer", ""));
    }

    @Override
    public Stub<String> buildBetaNode(Stub<String> primaryStub, Stub<String> sideStub, TupleMask primaryMask, TupleMask sideMask, TupleMask complementer, boolean negative) {
        String[] arguments = new String[]{this.gen(primaryStub), this.gen(sideStub), this.gen(primaryMask), this.gen(sideMask), this.gen(complementer), this.gen(negative)};
        String resultVar = this.emitFunctionCall(this.coordinator.stubType, "buildBetaNode", arguments);
        if (negative) {
            return new Stub<String>(primaryStub, resultVar);
        }
        Tuple newCalibrationPattern = negative ? primaryStub.getVariablesTuple() : complementer.combine(primaryStub.getVariablesTuple(), sideStub.getVariablesTuple(), true, true);
        return new Stub<String>(primaryStub, sideStub, newCalibrationPattern, resultVar);
    }

    @Override
    public Stub<String> buildCountCheckBetaNode(Stub<String> primaryStub, Stub<String> sideStub, TupleMask primaryMask, TupleMask originalSideMask, int resultPositionInSignature) {
        String[] arguments = new String[]{this.gen(primaryStub), this.gen(sideStub), this.gen(primaryMask), this.gen(originalSideMask), this.gen(resultPositionInSignature)};
        String resultVar = this.emitFunctionCall(this.coordinator.stubType, "buildCountCheckBetaNode", arguments);
        return new Stub<String>(primaryStub, primaryStub.getVariablesTuple(), resultVar);
    }

    @Override
    public Stub<String> buildCounterBetaNode(Stub<String> primaryStub, Stub<String> sideStub, TupleMask primaryMask, TupleMask originalSideMask, TupleMask complementer, Object aggregateResultCalibrationElement) {
        String[] arguments = new String[]{this.gen(primaryStub), this.gen(sideStub), this.gen(primaryMask), this.gen(originalSideMask), this.gen(complementer), this.genCalibrationElement(aggregateResultCalibrationElement)};
        String resultVar = this.emitFunctionCall(this.coordinator.stubType, "buildCounterBetaNode", arguments);
        Object[] newCalibrationElement = new Object[]{aggregateResultCalibrationElement};
        LeftInheritanceTuple newCalibrationPattern = new LeftInheritanceTuple(primaryStub.getVariablesTuple(), newCalibrationElement);
        return new Stub<String>(primaryStub, (Tuple)newCalibrationPattern, resultVar);
    }

    @Override
    public void buildConnection(Stub<String> stub, String collector) {
        String[] arguments = new String[]{this.gen(stub), collector};
        this.emitProcedureCall("buildConnection", arguments);
    }

    @Override
    public Stub<String> buildEqualityChecker(Stub<String> stub, int[] indices) {
        String[] arguments = new String[]{this.gen(stub), this.gen(indices)};
        String resultVar = this.emitFunctionCall(this.coordinator.stubType, "buildEqualityChecker", arguments);
        return new Stub<String>(stub, resultVar);
    }

    @Override
    public Stub<String> buildInjectivityChecker(Stub<String> stub, int subject, int[] inequalIndices) {
        String[] arguments = new String[]{this.gen(stub), this.gen(subject), this.gen(inequalIndices)};
        String resultVar = this.emitFunctionCall(this.coordinator.stubType, "buildInjectivityChecker", arguments);
        return new Stub<String>(stub, resultVar);
    }

    @Override
    public Stub<String> buildTransitiveClosure(Stub<String> stub) {
        String[] arguments = new String[]{this.gen(stub)};
        String resultVar = this.emitFunctionCall(this.coordinator.stubType, "buildTransitiveClosure", arguments);
        return new Stub<String>(stub, resultVar);
    }

    @Override
    public Stub<String> buildScopeConstrainer(Stub<String> stub, boolean transitive, Object unwrappedContainer, int constrainedIndex) {
        throw new UnsupportedOperationException("Code generation does not support external scoping as of now");
    }

    @Override
    public Stub<String> buildStartStub(Object[] constantValues, Object[] constantNames) {
        String[] arguments = new String[]{this.gen(constantValues, true), this.gen(constantNames, false)};
        String resultVar = this.emitFunctionCall(this.coordinator.stubType, "buildStartStub", arguments);
        return new Stub<String>(new FlatTuple(constantNames), resultVar);
    }

    @Override
    public Stub<String> buildTrimmer(Stub<String> stub, TupleMask trimMask, boolean enforceUniqueness) {
        String[] arguments = new String[]{this.gen(stub), this.gen(trimMask), this.gen(enforceUniqueness)};
        String resultVar = this.emitFunctionCall(this.coordinator.stubType, "buildTrimmer", arguments);
        return new Stub<String>(stub, trimMask.transform(stub.getVariablesTuple()), resultVar);
    }

    @Override
    public Stub<String> containmentDirectStub(Tuple nodes) {
        String[] arguments = new String[]{this.gen(nodes, false)};
        String resultVar = this.emitFunctionCall(this.coordinator.stubType, "containmentDirectStub", arguments);
        return new Stub<String>(nodes, resultVar);
    }

    @Override
    public Stub<String> containmentTransitiveStub(Tuple nodes) {
        String[] arguments = new String[]{this.gen(nodes, false)};
        String resultVar = this.emitFunctionCall(this.coordinator.stubType, "containmentTransitiveStub", arguments);
        return new Stub<String>(nodes, resultVar);
    }

    @Override
    public Stub<String> unaryTypeStub(Tuple nodes, Object supplierKey) {
        String[] arguments = new String[]{this.gen(nodes, false), this.declareNewValue("Object", this.genUnaryType(supplierKey))};
        String resultVar = this.emitFunctionCall(this.coordinator.stubType, "unaryTypeStub", arguments);
        return new Stub<String>(nodes, resultVar);
    }

    @Override
    public Stub<String> generalizationDirectStub(Tuple nodes) {
        String[] arguments = new String[]{this.gen(nodes, false)};
        String resultVar = this.emitFunctionCall(this.coordinator.stubType, "generalizationDirectStub", arguments);
        return new Stub<String>(nodes, resultVar);
    }

    @Override
    public Stub<String> generalizationTransitiveStub(Tuple nodes) {
        String[] arguments = new String[]{this.gen(nodes, false)};
        String resultVar = this.emitFunctionCall(this.coordinator.stubType, "generalizationTransitiveStub", arguments);
        return new Stub<String>(nodes, resultVar);
    }

    @Override
    public Stub<String> instantiationDirectStub(Tuple nodes) {
        String[] arguments = new String[]{this.gen(nodes, false)};
        String resultVar = this.emitFunctionCall(this.coordinator.stubType, "instantiationDirectStub", arguments);
        return new Stub<String>(nodes, resultVar);
    }

    @Override
    public Stub<String> instantiationTransitiveStub(Tuple nodes) {
        String[] arguments = new String[]{this.gen(nodes, false)};
        String resultVar = this.emitFunctionCall(this.coordinator.stubType, "instantiationTransitiveStub", arguments);
        return new Stub<String>(nodes, resultVar);
    }

    @Override
    public Stub<String> patternCallStub(Tuple nodes, PatternDescription supplierKey) {
        String[] arguments = new String[]{this.gen(nodes, false), this.genPattern(supplierKey)};
        String resultVar = this.emitFunctionCall(this.coordinator.stubType, "patternCallStub", arguments);
        return new Stub<String>(nodes, resultVar);
    }

    @Override
    public Stub<String> binaryEdgeTypeStub(Tuple nodes, Object supplierKey) {
        String[] arguments = new String[]{this.gen(nodes, false), this.declareNewValue("Object", this.genBinaryEdgeType(supplierKey))};
        String resultVar = this.emitFunctionCall(this.coordinator.stubType, "binaryEdgeTypeStub", arguments);
        return new Stub<String>(nodes, resultVar);
    }

    @Override
    public Stub<String> ternaryEdgeTypeStub(Tuple nodes, Object supplierKey) {
        String[] arguments = new String[]{this.gen(nodes, false), this.declareNewValue("Object", this.genTernaryEdgeType(supplierKey))};
        String resultVar = this.emitFunctionCall(this.coordinator.stubType, "ternaryEdgeTypeStub", arguments);
        return new Stub<String>(nodes, resultVar);
    }

    @Override
    public String patternCollector(PatternDescription pattern) {
        String patternName = this.genPattern(pattern);
        String[] arguments = new String[]{patternName};
        return this.emitFunctionCall(this.coordinator.collectorType, "patternCollector", arguments);
    }

    @Override
    public void patternFinished(PatternDescription pattern, IPatternMatcherContext<PatternDescription> context, String collector) {
    }
}

