/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;

public class ClassLoaderUtil {
    public static ClassLoader getClassLoader(IFile file) throws CoreException, MalformedURLException {
        if (file != null) {
            IProject project = file.getProject();
            IJavaProject jp = JavaCore.create((IProject)project);
            String[] classPathEntries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)jp);
            List<URL> classURLs = ClassLoaderUtil.getClassesAsURLs(classPathEntries);
            URL[] urls = classURLs.toArray(new URL[classURLs.size()]);
            URLClassLoader loader = URLClassLoader.newInstance(urls, jp.getClass().getClassLoader());
            return loader;
        }
        return null;
    }

    private static List<URL> getClassesAsURLs(String[] classPathEntries) throws MalformedURLException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        int i = 0;
        while (i < classPathEntries.length) {
            String entry = classPathEntries[i];
            Path path = new Path(entry);
            URL url = path.toFile().toURI().toURL();
            urlList.add(url);
            ++i;
        }
        return urlList;
    }
}

