/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.incquery.viewers.runtime.model.Containment;
import org.eclipse.incquery.viewers.runtime.model.Edge;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataModel;
import org.eclipse.incquery.viewers.runtime.model.listeners.IViewerStateListener;

public final class ViewerState {
    private IObservableList itemList;
    private IObservableList edgeList;
    private IObservableList containmentList;
    private Multimap<Item, Item> childrenMap;
    private Map<Item, Item> parentMap;
    private ViewerDataModel model;
    private ListenerList stateListeners = new ListenerList();
    private IListChangeListener itemListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            ListDiff diff = event.diff;
            ListDiffEntry[] listDiffEntryArray = diff.getDifferences();
            int n = listDiffEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener;
                int n3;
                int n4;
                Object[] objectArray;
                ListDiffEntry entry = listDiffEntryArray[n2];
                Item item = (Item)entry.getElement();
                if (entry.isAddition()) {
                    objectArray = ViewerState.this.stateListeners.getListeners();
                    n4 = objectArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        listener = objectArray[n3];
                        ((IViewerStateListener)listener).itemAppeared(item);
                        ++n3;
                    }
                } else {
                    objectArray = ViewerState.this.stateListeners.getListeners();
                    n4 = objectArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        listener = objectArray[n3];
                        ((IViewerStateListener)listener).itemDisappeared(item);
                        ++n3;
                    }
                }
                ++n2;
            }
        }
    };
    private IListChangeListener edgeListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            ListDiff diff = event.diff;
            ListDiffEntry[] listDiffEntryArray = diff.getDifferences();
            int n = listDiffEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener;
                int n3;
                int n4;
                Object[] objectArray;
                ListDiffEntry entry = listDiffEntryArray[n2];
                Edge edge = (Edge)entry.getElement();
                if (entry.isAddition()) {
                    objectArray = ViewerState.this.stateListeners.getListeners();
                    n4 = objectArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        listener = objectArray[n3];
                        ((IViewerStateListener)listener).edgeAppeared(edge);
                        ++n3;
                    }
                } else {
                    objectArray = ViewerState.this.stateListeners.getListeners();
                    n4 = objectArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        listener = objectArray[n3];
                        ((IViewerStateListener)listener).edgeDisappeared(edge);
                        ++n3;
                    }
                }
                ++n2;
            }
        }
    };
    private IListChangeListener containmentListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            ListDiff diff = event.diff;
            ListDiffEntry[] listDiffEntryArray = diff.getDifferences();
            int n = listDiffEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ListDiffEntry entry = listDiffEntryArray[n2];
                Containment edge = (Containment)entry.getElement();
                if (entry.isAddition()) {
                    ViewerState.this.containmentAppeared(edge);
                } else {
                    ViewerState.this.containmentDisappeared(edge);
                }
                ++n2;
            }
        }
    };

    public ViewerDataModel getModel() {
        return this.model;
    }

    public ViewerState(ViewerDataModel model, ViewerDataFilter filter, Collection<ViewerStateFeature> features) {
        this.model = model;
        this.initializeItemList(model.initializeObservableItemList(filter));
        for (ViewerStateFeature feature : features) {
            switch (feature) {
                case EDGE: {
                    this.initializeEdgeList((IObservableList)model.initializeObservableEdgeList(filter));
                    break;
                }
                case CONTAINMENT: {
                    this.initializeContainmentList((IObservableList)model.initializeObservableContainmentList(filter));
                }
            }
        }
    }

    public IObservableList getItemList() {
        return this.itemList;
    }

    private void initializeItemList(IObservableList itemList) {
        if (this.itemList != null) {
            this.removeItemListener(itemList);
        }
        this.itemList = itemList;
        this.addItemListener(itemList);
    }

    private void addItemListener(IObservableList containmentList) {
        containmentList.addListChangeListener(this.itemListener);
    }

    private void removeItemListener(IObservableList oldContainmentList) {
        oldContainmentList.removeListChangeListener(this.itemListener);
    }

    public IObservableList getEdgeList() {
        return this.edgeList;
    }

    private void initializeEdgeList(IObservableList edgeList) {
        if (this.edgeList != null) {
            this.removeEdgeListener(this.edgeList);
        }
        this.edgeList = edgeList;
        this.addEdgeListener(edgeList);
    }

    private void addEdgeListener(IObservableList edgeList) {
        edgeList.addListChangeListener(this.edgeListener);
    }

    private void removeEdgeListener(IObservableList oldEdgeList) {
        oldEdgeList.removeListChangeListener(this.edgeListener);
    }

    public IObservableList getContainmentList() {
        return this.containmentList;
    }

    public Collection<Item> getChildren(Item parent) {
        return this.childrenMap.get((Object)parent);
    }

    public Item getParent(Item child) {
        return this.parentMap.get(child);
    }

    private void initializeContainmentList(IObservableList containmentList) {
        if (this.containmentList != null) {
            this.removeContainmentListener(this.containmentList);
        }
        this.containmentList = containmentList;
        this.childrenMap = HashMultimap.create();
        this.parentMap = Maps.newHashMap();
        for (Object obj : containmentList) {
            Containment containment = (Containment)obj;
            this.containmentAppeared(containment);
        }
        this.addContainmentListener(containmentList);
    }

    private void containmentAppeared(Containment containment) {
        this.childrenMap.put((Object)containment.getSource(), (Object)containment.getTarget());
        this.parentMap.put(containment.getTarget(), containment.getSource());
        Object[] objectArray = this.stateListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IViewerStateListener)listener).containmentAppeared(containment);
            ++n2;
        }
    }

    private void containmentDisappeared(Containment containment) {
        this.childrenMap.remove((Object)containment.getSource(), (Object)containment.getTarget());
        this.parentMap.remove(containment.getTarget());
        Object[] objectArray = this.stateListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IViewerStateListener)listener).containmentDisappeared(containment);
            ++n2;
        }
    }

    private void addContainmentListener(IObservableList oldContainmentList) {
        oldContainmentList.addListChangeListener(this.containmentListener);
    }

    private void removeContainmentListener(IObservableList oldContainmentList) {
        oldContainmentList.removeListChangeListener(this.containmentListener);
    }

    public void addStateListener(IViewerStateListener listener) {
        this.stateListeners.add((Object)listener);
    }

    public void removeStateListener(IViewerStateListener listener) {
        this.stateListeners.remove((Object)listener);
    }

    public static enum ViewerStateFeature {
        EDGE,
        CONTAINMENT;

    }
}

